/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import keycloakjar.org.springframework.core.task.AsyncListenableTaskExecutor;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.client.AbstractBufferingAsyncClientHttpRequest;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.SimpleBufferingClientHttpRequest;
import keycloakjar.org.springframework.http.client.SimpleClientHttpResponse;
import keycloakjar.org.springframework.util.FileCopyUtils;
import keycloakjar.org.springframework.util.concurrent.ListenableFuture;

@Deprecated
final class SimpleBufferingAsyncClientHttpRequest
extends AbstractBufferingAsyncClientHttpRequest {
    private final HttpURLConnection connection;
    private final boolean outputStreaming;
    private final AsyncListenableTaskExecutor taskExecutor;

    SimpleBufferingAsyncClientHttpRequest(HttpURLConnection connection, boolean outputStreaming, AsyncListenableTaskExecutor taskExecutor) {
        this.connection = connection;
        this.outputStreaming = outputStreaming;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public String getMethodValue() {
        return this.connection.getRequestMethod();
    }

    @Override
    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected ListenableFuture<ClientHttpResponse> executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        return this.taskExecutor.submitListenable(() -> {
            SimpleBufferingClientHttpRequest.addHeaders(this.connection, headers);
            if (this.getMethod() == HttpMethod.DELETE && bufferedOutput.length == 0) {
                this.connection.setDoOutput(false);
            }
            if (this.connection.getDoOutput() && this.outputStreaming) {
                this.connection.setFixedLengthStreamingMode(bufferedOutput.length);
            }
            this.connection.connect();
            if (this.connection.getDoOutput()) {
                FileCopyUtils.copy(bufferedOutput, this.connection.getOutputStream());
            } else {
                this.connection.getResponseCode();
            }
            return new SimpleClientHttpResponse(this.connection);
        });
    }
}

