/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import keycloakjar.org.apache.http.HttpHost;
import keycloakjar.org.apache.http.auth.AuthScope;
import keycloakjar.org.apache.http.auth.UsernamePasswordCredentials;
import keycloakjar.org.apache.http.config.Registry;
import keycloakjar.org.apache.http.config.RegistryBuilder;
import keycloakjar.org.apache.http.conn.socket.ConnectionSocketFactory;
import keycloakjar.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import keycloakjar.org.apache.http.conn.ssl.NoopHostnameVerifier;
import keycloakjar.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import keycloakjar.org.apache.http.impl.client.BasicCredentialsProvider;
import keycloakjar.org.apache.http.impl.client.HttpClientBuilder;
import keycloakjar.org.apache.http.impl.client.LaxRedirectStrategy;
import keycloakjar.org.apache.http.impl.client.ProxyAuthenticationStrategy;
import keycloakjar.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import keycloakjar.org.apache.http.ssl.SSLContexts;
import keycloakjar.org.apache.http.ssl.TrustStrategy;
import keycloakjar.org.springframework.http.client.ClientHttpRequestInterceptor;
import keycloakjar.org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import keycloakjar.org.springframework.http.converter.StringHttpMessageConverter;
import keycloakjar.org.springframework.util.StringUtils;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderSession;
import org.camunda.bpm.extension.keycloak.cache.CacheConfiguration;
import org.camunda.bpm.extension.keycloak.cache.CacheFactory;
import org.camunda.bpm.extension.keycloak.cache.QueryCache;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;

public class KeycloakIdentityProviderFactory
implements SessionFactory {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakContextProvider keycloakContextProvider;
    protected QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache;
    protected QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache;
    protected KeycloakRestTemplate restTemplate = new KeycloakRestTemplate();

    public KeycloakIdentityProviderFactory(KeycloakConfiguration keycloakConfiguration, List<ClientHttpRequestInterceptor> customHttpRequestInterceptors) {
        this.keycloakConfiguration = keycloakConfiguration;
        CacheConfiguration cacheConfiguration = CacheConfiguration.from(keycloakConfiguration);
        this.setUserQueryCache(CacheFactory.create(cacheConfiguration));
        this.setGroupQueryCache(CacheFactory.create(cacheConfiguration));
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder httpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy());
        if (keycloakConfiguration.isDisableSSLCertificateValidation()) {
            try {
                TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
                Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts)).register("http", (SSLConnectionSocketFactory)((Object)new PlainConnectionSocketFactory())).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
                httpClient.setConnectionManager(connectionManager);
            }
            catch (GeneralSecurityException e) {
                throw new IdentityProviderException("Disabling SSL certificate validation failed", (Throwable)e);
            }
        } else {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
            httpClient.setConnectionManager(connectionManager);
        }
        if (StringUtils.hasLength(keycloakConfiguration.getProxyUri())) {
            URI proxyUri = URI.create(keycloakConfiguration.getProxyUri());
            HttpHost proxy = new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme());
            httpClient.setProxy(proxy);
            if (StringUtils.hasLength(keycloakConfiguration.getProxyUser()) && keycloakConfiguration.getProxyPassword() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), new UsernamePasswordCredentials(keycloakConfiguration.getProxyUser(), keycloakConfiguration.getProxyPassword()));
                httpClient.setDefaultCredentialsProvider(credentialsProvider).setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy());
            }
        }
        factory.setHttpClient(httpClient.build());
        this.restTemplate.setRequestFactory(factory);
        for (int i = 0; i < this.restTemplate.getMessageConverters().size(); ++i) {
            if (!(this.restTemplate.getMessageConverters().get(i) instanceof StringHttpMessageConverter)) continue;
            this.restTemplate.getMessageConverters().set(i, new StringHttpMessageConverter(Charset.forName(keycloakConfiguration.getCharset())));
            break;
        }
        this.restTemplate.getInterceptors().addAll(customHttpRequestInterceptors);
        this.keycloakContextProvider = new KeycloakContextProvider(keycloakConfiguration, this.restTemplate);
    }

    public Class<?> getSessionType() {
        return ReadOnlyIdentityProvider.class;
    }

    public void setUserQueryCache(QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache) {
        this.userQueryCache = userQueryCache;
    }

    public void setGroupQueryCache(QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache) {
        this.groupQueryCache = groupQueryCache;
    }

    public void clearCache() {
        this.userQueryCache.clear();
        this.groupQueryCache.clear();
    }

    public Session openSession() {
        return new KeycloakIdentityProviderSession(this.keycloakConfiguration, this.restTemplate, this.keycloakContextProvider, this.userQueryCache, this.groupQueryCache);
    }
}

