/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.core.io.buffer.PooledDataBuffer;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;
    private final ReactiveRequest.Builder builder;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
        this.builder = ReactiveRequest.newBuilder((Request)this.jettyRequest).abortOnCancel(true);
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.jettyRequest.getMethod());
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit();
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.jettyRequest;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return Mono.create(sink -> {
            ReactiveRequest.Content content = (ReactiveRequest.Content)Flux.from((Publisher)body).map(buffer -> this.toContentChunk((DataBuffer)buffer, (MonoSink<Void>)sink)).as(chunks -> ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)this.getContentType()));
            this.builder.content(content);
            sink.success();
        }).then(this.doCommit());
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMap(Function.identity()).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release));
    }

    private String getContentType() {
        MediaType contentType = this.getHeaders().getContentType();
        return contentType != null ? contentType.toString() : "application/octet-stream";
    }

    private ContentChunk toContentChunk(final DataBuffer buffer, final MonoSink<Void> sink) {
        return new ContentChunk(buffer.asByteBuffer(), new Callback(){

            public void succeeded() {
                DataBufferUtils.release(buffer);
            }

            public void failed(Throwable t) {
                DataBufferUtils.release(buffer);
                sink.error(t);
            }
        });
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue())).forEach(arg_0 -> ((Request)this.jettyRequest).cookie(arg_0));
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        headers.forEach((key, value) -> value.forEach(v -> this.jettyRequest.header(key, v)));
        if (!headers.containsKey("Accept")) {
            this.jettyRequest.header("Accept", "*/*");
        }
    }

    public ReactiveRequest toReactiveRequest() {
        return this.builder.build();
    }
}

