/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.lang.reflect.Method;
import java.net.HttpCookie;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.ResponseCookie;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.reactive.JettyHeadersAdapter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.ReflectionUtils;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class JettyClientHttpResponse
implements ClientHttpResponse {
    private static final Pattern SAMESITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");
    private static final ClassLoader classLoader = JettyClientHttpResponse.class.getClassLoader();
    private static final boolean jetty10Present;
    private final ReactiveResponse reactiveResponse;
    private final Flux<DataBuffer> content;
    private final HttpHeaders headers;

    public JettyClientHttpResponse(ReactiveResponse reactiveResponse, Publisher<DataBuffer> content) {
        this.reactiveResponse = reactiveResponse;
        this.content = Flux.from(content);
        MultiValueMap<String, String> headers = jetty10Present ? Jetty10HttpFieldsHelper.getHttpHeaders(reactiveResponse) : new JettyHeadersAdapter(reactiveResponse.getHeaders());
        this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(this.getRawStatusCode());
    }

    @Override
    public int getRawStatusCode() {
        return this.reactiveResponse.getStatus();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        Object cookieHeader = this.getHeaders().get("Set-Cookie");
        if (cookieHeader != null) {
            cookieHeader.forEach(header -> HttpCookie.parse(header).forEach(cookie -> result.add(cookie.getName(), ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(cookie.getMaxAge()).secure(cookie.getSecure()).httpOnly(cookie.isHttpOnly()).sameSite(JettyClientHttpResponse.parseSameSite(header)).build())));
        }
        return CollectionUtils.unmodifiableMultiValueMap(result);
    }

    @Nullable
    private static String parseSameSite(String headerValue) {
        Matcher matcher = SAMESITE_PATTERN.matcher(headerValue);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.content;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    static {
        try {
            Class<?> httpFieldsClass = classLoader.loadClass("org.eclipse.jetty.http.HttpFields");
            jetty10Present = httpFieldsClass.isInterface();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("No compatible Jetty version found", ex);
        }
    }

    private static class Jetty10HttpFieldsHelper {
        private static final Method getHeadersMethod;
        private static final Method getNameMethod;
        private static final Method getValueMethod;

        private Jetty10HttpFieldsHelper() {
        }

        public static HttpHeaders getHttpHeaders(ReactiveResponse response) {
            HttpHeaders headers = new HttpHeaders();
            Iterable iterator = (Iterable)ReflectionUtils.invokeMethod(getHeadersMethod, response.getResponse());
            Assert.notNull((Object)iterator, "Iterator must not be null");
            for (Object field : iterator) {
                String name = (String)ReflectionUtils.invokeMethod(getNameMethod, field);
                Assert.notNull((Object)name, "Header name must not be null");
                String value = (String)ReflectionUtils.invokeMethod(getValueMethod, field);
                headers.add(name, value);
            }
            return headers;
        }

        static {
            try {
                getHeadersMethod = Response.class.getMethod("getHeaders", new Class[0]);
                Class<?> type = classLoader.loadClass("org.eclipse.jetty.http.HttpField");
                getNameMethod = type.getMethod("getName", new Class[0]);
                getValueMethod = type.getMethod("getValue", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                throw new IllegalStateException("No compatible Jetty version found", ex);
            }
        }
    }
}

