/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.util.Arrays;
import java.util.List;
import keycloakjar.com.google.gson.JsonArray;
import keycloakjar.com.google.gson.JsonObject;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakGroupNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakUserNotFoundException;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public abstract class KeycloakServiceBase {
    protected KeycloakConfiguration keycloakConfiguration;
    protected RestTemplate restTemplate;
    protected KeycloakContextProvider keycloakContextProvider;

    public KeycloakServiceBase(KeycloakConfiguration keycloakConfiguration, RestTemplate restTemplate, KeycloakContextProvider keycloakContextProvider) {
        this.keycloakConfiguration = keycloakConfiguration;
        this.restTemplate = restTemplate;
        this.keycloakContextProvider = keycloakContextProvider;
    }

    protected String getKeycloakUserID(String userId) throws KeycloakUserNotFoundException, RestClientException {
        String userSearch;
        if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
            userSearch = "/users?email=" + userId;
        } else if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            userSearch = "/users?username=" + userId;
        } else {
            return userId;
        }
        try {
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + userSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            JsonArray resultList = JsonUtil.parseAsJsonArray((String)response.getBody());
            JsonObject result = JsonUtil.findFirst(resultList, this.keycloakConfiguration.isUseUsernameAsCamundaUserId() ? "username" : "email", userId);
            if (result != null) {
                return JsonUtil.getJsonString(result, "id");
            }
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - username unknown"));
        }
        catch (JsonException je) {
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - username unknown"), je);
        }
    }

    protected String getKeycloakGroupID(String groupId) throws KeycloakGroupNotFoundException, RestClientException {
        if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) {
            return groupId;
        }
        String groupSearch = "/group-by-path/" + groupId;
        try {
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + groupSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response.getBody(), "id");
        }
        catch (JsonException je) {
            throw new KeycloakGroupNotFoundException(groupId + " not found - path unknown", je);
        }
    }

    protected String getMaxQueryResultSize() {
        return Integer.toString(this.keycloakConfiguration.getMaxResultSize());
    }

    protected <T> List<T> truncate(List<T> list, int maxSize) {
        if (list == null) {
            return list;
        }
        int actualSize = list.size();
        if (actualSize <= maxSize) {
            return list;
        }
        return list.subList(0, maxSize);
    }

    protected void addArgument(StringBuilder filter, String name, String value) {
        if (filter.length() > 0) {
            filter.append("&");
        }
        filter.append(name).append('=').append(value);
    }

    protected boolean matches(Object queryParameter, Object attribute) {
        return queryParameter == null || queryParameter.equals(attribute);
    }

    protected boolean matches(Object[] queryParameter, Object attribute) {
        return queryParameter == null || queryParameter.length == 0 || Arrays.asList(queryParameter).contains(attribute);
    }

    protected boolean matchesLike(String queryParameter, String attribute) {
        return queryParameter == null || attribute.matches(queryParameter.replaceAll("[%\\*]", ".*"));
    }

    protected static int compare(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    protected boolean isAuthenticatedUser(UserEntity user) {
        return this.isAuthenticatedUser(user.getId());
    }

    protected boolean isAuthenticatedUser(String userId) {
        if (userId == null) {
            return false;
        }
        return userId.equalsIgnoreCase(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        return !this.keycloakConfiguration.isAuthorizationCheckEnabled() || Context.getCommandContext().getAuthorizationManager().isAuthorized(permission, resource, resourceId);
    }
}

