/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;

public class KeycloakContext {
    private HttpHeaders headers = new HttpHeaders();
    private long expiresAt;
    String refreshToken;

    public KeycloakContext(String accessToken, String tokenType, long expiresInMillis, String refreshToken) {
        this.headers.add("Content-Type", "application/json");
        this.headers.add("Authorization", tokenType + " " + accessToken);
        this.expiresAt = System.currentTimeMillis() + expiresInMillis - 2000L;
        this.refreshToken = refreshToken;
    }

    public HttpEntity<String> createHttpRequestEntity() {
        return new HttpEntity((MultiValueMap)this.headers);
    }

    public boolean needsRefresh() {
        return System.currentTimeMillis() >= this.expiresAt;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }
}

