/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderSession;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class KeycloakIdentityProviderFactory
implements SessionFactory {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakContextProvider keycloakContextProvider;
    protected RestTemplate restTemplate = new RestTemplate();

    public KeycloakIdentityProviderFactory(KeycloakConfiguration keycloakConfiguration) {
        this.keycloakConfiguration = keycloakConfiguration;
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        if (keycloakConfiguration.isDisableSSLCertificateValidation()) {
            try {
                TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts)).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
                httpClient.setConnectionManager((HttpClientConnectionManager)connectionManager);
            }
            catch (GeneralSecurityException e) {
                throw new IdentityProviderException("Disabling SSL certificate validation failed", (Throwable)e);
            }
        } else {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
            httpClient.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        factory.setHttpClient((HttpClient)httpClient.build());
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
        this.restTemplate.getMessageConverters().add(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        this.keycloakContextProvider = new KeycloakContextProvider(keycloakConfiguration, this.restTemplate);
    }

    public Class<?> getSessionType() {
        return ReadOnlyIdentityProvider.class;
    }

    public Session openSession() {
        return new KeycloakIdentityProviderSession(this.keycloakConfiguration, this.restTemplate, this.keycloakContextProvider);
    }
}

