/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.plugin;

import java.util.ArrayList;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderFactory;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderSession;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;
import org.springframework.util.StringUtils;

public class KeycloakIdentityProviderPlugin
extends KeycloakConfiguration
implements ProcessEnginePlugin {
    private static final KeycloakPluginLogger LOG = KeycloakPluginLogger.INSTANCE;
    private boolean authorizationEnabled;
    private KeycloakIdentityProviderFactory keycloakIdentityProviderFactory = null;

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.checkMandatoryConfigurationParameters(processEngineConfiguration);
        this.authorizationEnabled = processEngineConfiguration.isAuthorizationEnabled();
        if (!StringUtils.isEmpty((Object)this.administratorGroupName) && processEngineConfiguration.getAdminGroups() == null) {
            processEngineConfiguration.setAdminGroups(new ArrayList());
        }
        if (!StringUtils.isEmpty((Object)this.administratorUserId) && processEngineConfiguration.getAdminUsers() == null) {
            processEngineConfiguration.setAdminUsers(new ArrayList());
        }
        this.keycloakIdentityProviderFactory = new KeycloakIdentityProviderFactory(this);
        processEngineConfiguration.setIdentityProviderSessionFactory((SessionFactory)this.keycloakIdentityProviderFactory);
        LOG.pluginActivated(this.getClass().getSimpleName(), processEngineConfiguration.getProcessEngineName());
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public void postProcessEngineBuild(ProcessEngine processEngine) {
        String administratorGroupId = null;
        if (!StringUtils.isEmpty((Object)this.administratorGroupName)) {
            Group administratorGroup = (Group)processEngine.getIdentityService().createGroupQuery().groupName(this.administratorGroupName).singleResult();
            administratorGroupId = administratorGroup != null ? administratorGroup.getId() : this.administratorGroupName;
            ((ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration()).getAdminGroups().add(administratorGroupId);
        }
        if (!StringUtils.isEmpty((Object)this.administratorUserId)) {
            this.administratorUserId = ((KeycloakIdentityProviderSession)this.keycloakIdentityProviderFactory.openSession()).getKeycloakAdminUserId(this.administratorUserId);
            ((ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration()).getAdminUsers().add(this.administratorUserId);
        }
        if (!this.authorizationEnabled) {
            return;
        }
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (!StringUtils.isEmpty((Object)this.administratorGroupName)) {
            for (Resources resource : Resources.values()) {
                if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{administratorGroupId}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
                AuthorizationEntity adminGroupAuth = new AuthorizationEntity(1);
                adminGroupAuth.setGroupId(administratorGroupId);
                adminGroupAuth.setResource((Resource)resource);
                adminGroupAuth.setResourceId("*");
                adminGroupAuth.addPermission((Permission)Permissions.ALL);
                authorizationService.saveAuthorization((Authorization)adminGroupAuth);
                LOG.grantGroupPermissions(this.administratorGroupName, administratorGroupId, resource.resourceName());
            }
        }
        if (!StringUtils.isEmpty((Object)this.administratorUserId)) {
            for (Resources resource : Resources.values()) {
                if (authorizationService.createAuthorizationQuery().userIdIn(new String[]{this.administratorUserId}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
                AuthorizationEntity adminUserAuth = new AuthorizationEntity(1);
                adminUserAuth.setUserId(this.administratorUserId);
                adminUserAuth.setResource((Resource)resource);
                adminUserAuth.setResourceId("*");
                adminUserAuth.addPermission((Permission)Permissions.ALL);
                authorizationService.saveAuthorization((Authorization)adminUserAuth);
                LOG.grantUserPermissions(this.administratorUserId, resource.resourceName());
            }
        }
    }

    private void checkMandatoryConfigurationParameters(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList<String> missing = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)this.keycloakIssuerUrl)) {
            LOG.missingConfigurationParameter("keycloakIssuerUrl");
            missing.add("keycloakIssuerUrl");
        }
        if (StringUtils.isEmpty((Object)this.keycloakAdminUrl)) {
            LOG.missingConfigurationParameter("keycloakAdminUrl");
            missing.add("keycloakAdminUrl");
        }
        if (StringUtils.isEmpty((Object)this.clientId)) {
            LOG.missingConfigurationParameter("clientId");
            missing.add("clientId");
        }
        if (StringUtils.isEmpty((Object)this.clientSecret)) {
            LOG.missingConfigurationParameter("clientSecret");
            missing.add("clientSecret");
        }
        if (missing.size() > 0) {
            LOG.activationError(this.getClass().getSimpleName(), processEngineConfiguration.getProcessEngineName(), "missing mandatory configuration parameters " + ((Object)missing).toString());
            throw new IllegalStateException("Unable to initialize plugin " + this.getClass().getSimpleName() + ": - missing mandatory configuration parameters: " + ((Object)missing).toString());
        }
        if (this.isUseEmailAsCamundaUserId() && this.isUseUsernameAsCamundaUserId()) {
            LOG.activationError(this.getClass().getSimpleName(), processEngineConfiguration.getProcessEngineName(), "cannot use configuration parameters 'useUsernameAsCamundaUserId' AND 'useEmailAsCamundaUserId' at the same time");
            throw new IllegalStateException("Unable to initialize plugin " + this.getClass().getSimpleName() + ": - cannot use configuration parameters 'useUsernameAsCamundaUserId' AND 'useEmailAsCamundaUserId' at the same time");
        }
    }
}

