/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.NativeUserQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.GroupQueryProperty;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.UserQueryProperty;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakGroupNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.KeycloakTenantQuery;
import org.camunda.bpm.extension.keycloak.KeycloakUserNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.json.JSONArray;
import org.camunda.bpm.extension.keycloak.json.JSONException;
import org.camunda.bpm.extension.keycloak.json.JSONObject;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class KeycloakIdentityProviderSession
implements ReadOnlyIdentityProvider {
    protected KeycloakConfiguration keycloakConfiguration;
    protected RestTemplate restTemplate;
    protected KeycloakContextProvider keycloakContextProvider;

    public KeycloakIdentityProviderSession(KeycloakConfiguration keycloakConfiguration, RestTemplate restTemplate, KeycloakContextProvider keycloakContextProvider) {
        this.keycloakConfiguration = keycloakConfiguration;
        this.restTemplate = restTemplate;
        this.keycloakContextProvider = keycloakContextProvider;
    }

    public void flush() {
    }

    public void close() {
    }

    public User findUserById(String userId) {
        return (User)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult();
    }

    public UserQuery createUserQuery() {
        return new KeycloakUserQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return new KeycloakUserQuery();
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new BadUserRequestException("Native user queries are not supported for Keycloak identity service provider.");
    }

    protected long findUserCountByQueryCriteria(KeycloakUserQuery userQuery) {
        return this.findUserByQueryCriteria(userQuery).size();
    }

    protected List<User> findUserByQueryCriteria(KeycloakUserQuery userQuery) {
        if (!StringUtils.isEmpty((Object)userQuery.getGroupId())) {
            return this.requestUsersByGroupId(userQuery);
        }
        return this.requestUsersWithoutGroupId(userQuery);
    }

    protected List<User> requestUsersByGroupId(KeycloakUserQuery query) {
        String groupId = query.getGroupId();
        List<Object> userList = new ArrayList<User>();
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak user query results: [");
        }
        try {
            String keyCloakID;
            try {
                keyCloakID = this.getKeycloakGroupID(groupId);
            }
            catch (KeycloakGroupNotFoundException e) {
                return userList;
            }
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/groups/" + keyCloakID + "/members", HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read group members from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JSONArray searchResult = new JSONArray((String)response.getBody());
            for (int i = 0; i < searchResult.length(); ++i) {
                JSONObject keycloakUser = searchResult.getJSONObject(i);
                if (this.keycloakConfiguration.isUseEmailAsCamundaUserId() && StringUtils.isEmpty((Object)this.getStringValue(keycloakUser, "email")) || this.keycloakConfiguration.isUseUsernameAsCamundaUserId() && StringUtils.isEmpty((Object)this.getStringValue(keycloakUser, "username"))) continue;
                UserEntity user = this.transformUser(keycloakUser);
                if (!this.matches(query.getId(), (Object)user.getId()) || !this.matches(query.getIds(), (Object)user.getId()) || !this.matches(query.getEmail(), (Object)user.getEmail()) || !this.matchesLike(query.getEmailLike(), user.getEmail()) || !this.matches(query.getFirstName(), (Object)user.getFirstName()) || !this.matchesLike(query.getFirstNameLike(), user.getFirstName()) || !this.matches(query.getLastName(), (Object)user.getLastName()) || !this.matchesLike(query.getLastNameLike(), user.getLastName()) || !this.isAuthenticatedUser(user) && !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.USER, user.getId())) continue;
                userList.add((User)user);
                if (!KeycloakPluginLogger.INSTANCE.isDebugEnabled()) continue;
                resultLogger.append(user);
                resultLogger.append(" based on ");
                resultLogger.append(keycloakUser.toString());
                resultLogger.append(", ");
            }
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                return userList;
            }
            throw hcee;
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to query members of group " + groupId, (Throwable)rce);
        }
        catch (JSONException je) {
            throw new IdentityProviderException("Unable to query members of group " + groupId, (Throwable)je);
        }
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.userQueryResult(resultLogger.toString());
        }
        if (query.getOrderingProperties().size() > 0) {
            userList.sort(new UserComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            userList = userList.subList(query.getFirstResult(), Math.min(userList.size(), query.getFirstResult() + query.getMaxResults()));
        }
        return userList;
    }

    protected List<User> requestUsersWithoutGroupId(KeycloakUserQuery query) {
        List<Object> userList = new ArrayList<User>();
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak user query results: [");
        }
        try {
            ResponseEntity response = null;
            if (!StringUtils.isEmpty((Object)query.getId())) {
                response = this.requestUserById(query.getId());
            } else {
                String userFilter = this.createUserSearchFilter(query);
                response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users" + userFilter, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            }
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read users from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JSONArray searchResult = new JSONArray((String)response.getBody());
            for (int i = 0; i < searchResult.length(); ++i) {
                JSONObject keycloakUser = searchResult.getJSONObject(i);
                if (this.keycloakConfiguration.isUseEmailAsCamundaUserId() && StringUtils.isEmpty((Object)this.getStringValue(keycloakUser, "email")) || this.keycloakConfiguration.isUseUsernameAsCamundaUserId() && StringUtils.isEmpty((Object)this.getStringValue(keycloakUser, "username"))) continue;
                UserEntity user = this.transformUser(keycloakUser);
                if (!this.matches(query.getId(), (Object)user.getId()) || !this.matches(query.getEmail(), (Object)user.getEmail()) || !this.matches(query.getFirstName(), (Object)user.getFirstName()) || !this.matches(query.getLastName(), (Object)user.getLastName()) || !this.matches(query.getIds(), (Object)user.getId()) || !this.matchesLike(query.getEmailLike(), user.getEmail()) || !this.matchesLike(query.getFirstNameLike(), user.getFirstName()) || !this.matchesLike(query.getLastNameLike(), user.getLastName()) || !this.isAuthenticatedUser(user) && !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.USER, user.getId())) continue;
                userList.add((User)user);
                if (!KeycloakPluginLogger.INSTANCE.isDebugEnabled()) continue;
                resultLogger.append(user);
                resultLogger.append(" based on ");
                resultLogger.append(keycloakUser.toString());
                resultLogger.append(", ");
            }
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to query users", (Throwable)rce);
        }
        catch (JSONException je) {
            throw new IdentityProviderException("Unable to query users", (Throwable)je);
        }
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.userQueryResult(resultLogger.toString());
        }
        if (query.getOrderingProperties().size() > 0) {
            userList.sort(new UserComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            userList = userList.subList(query.getFirstResult(), Math.min(userList.size(), query.getFirstResult() + query.getMaxResults()));
        }
        return userList;
    }

    protected String createUserSearchFilter(KeycloakUserQuery query) {
        StringBuilder filter = new StringBuilder();
        if (!StringUtils.isEmpty((Object)query.getEmail())) {
            this.addArgument(filter, "email", query.getEmail());
        }
        if (!StringUtils.isEmpty((Object)query.getEmailLike())) {
            this.addArgument(filter, "email", query.getEmailLike().replaceAll("[%,\\*]", ""));
        }
        if (!StringUtils.isEmpty((Object)query.getFirstName())) {
            this.addArgument(filter, "firstName", query.getFirstName());
        }
        if (!StringUtils.isEmpty((Object)query.getFirstNameLike())) {
            this.addArgument(filter, "firstName", query.getFirstNameLike().replaceAll("[%,\\*]", ""));
        }
        if (!StringUtils.isEmpty((Object)query.getLastName())) {
            this.addArgument(filter, "lastName", query.getLastName());
        }
        if (!StringUtils.isEmpty((Object)query.getLastNameLike())) {
            this.addArgument(filter, "lastName", query.getLastNameLike().replaceAll("[%,\\*]", ""));
        }
        if (filter.length() > 0) {
            filter.insert(0, "?");
            String result = filter.toString();
            KeycloakPluginLogger.INSTANCE.userQueryFilter(result);
            return result;
        }
        return "";
    }

    protected ResponseEntity<String> requestUserById(String userId) throws RestClientException {
        try {
            String userSearch = this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? "/users?email=" + userId : (this.keycloakConfiguration.isUseUsernameAsCamundaUserId() ? "/users?username=" + userId : "/users/" + userId);
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + userSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            String result = this.keycloakConfiguration.isUseEmailAsCamundaUserId() || this.keycloakConfiguration.isUseUsernameAsCamundaUserId() ? (String)response.getBody() : "[" + (String)response.getBody() + "]";
            return new ResponseEntity((Object)result, (MultiValueMap)response.getHeaders(), response.getStatusCode());
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                String result = "[]";
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
            throw hcee;
        }
    }

    protected String getKeycloakUserID(String userId) throws KeycloakUserNotFoundException, RestClientException {
        String userSearch;
        if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
            userSearch = "/users?email=" + userId;
        } else if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            userSearch = "/users?username=" + userId;
        } else {
            return userId;
        }
        try {
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + userSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            return new JSONArray((String)response.getBody()).getJSONObject(0).getString("id");
        }
        catch (JSONException je) {
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - username unknown"), je);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKeycloakAdminUserId(String configuredAdminUserId) {
        try {
            ResponseEntity response2222 = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users/" + configuredAdminUserId, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
                return new JSONObject((String)response2222.getBody()).getString("email");
            }
            if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
                return new JSONObject((String)response2222.getBody()).getString("username");
            }
            return new JSONObject((String)response2222.getBody()).getString("id");
        }
        catch (JSONException | RestClientException response2222) {
            try {
                if (this.keycloakConfiguration.isUseEmailAsCamundaUserId() && configuredAdminUserId.contains("@")) {
                    try {
                        this.getKeycloakUserID(configuredAdminUserId);
                        return configuredAdminUserId;
                    }
                    catch (KeycloakUserNotFoundException response2222) {
                        // empty catch block
                    }
                }
                try {
                    ResponseEntity response3 = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users?username=" + configuredAdminUserId, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
                    if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
                        return new JSONArray((String)response3.getBody()).getJSONObject(0).getString("email");
                    }
                    if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
                        return new JSONArray((String)response3.getBody()).getJSONObject(0).getString("username");
                    }
                    return new JSONArray((String)response3.getBody()).getJSONObject(0).getString("id");
                }
                catch (JSONException response3) {
                    throw new IdentityProviderException("Configured administratorUserId " + configuredAdminUserId + " does not exist.");
                }
            }
            catch (RestClientException rce) {
                throw new IdentityProviderException("Unable to read data of configured administratorUserId " + configuredAdminUserId, (Throwable)rce);
            }
        }
    }

    protected UserEntity transformUser(JSONObject result) throws JSONException {
        UserEntity user = new UserEntity();
        if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
            user.setId(this.getStringValue(result, "email"));
        } else if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            user.setId(this.getStringValue(result, "username"));
        } else {
            user.setId(result.getString("id"));
        }
        user.setFirstName(this.getStringValue(result, "firstName"));
        user.setLastName(this.getStringValue(result, "lastName"));
        if (StringUtils.isEmpty((Object)user.getFirstName()) && StringUtils.isEmpty((Object)user.getLastName())) {
            user.setFirstName(this.getStringValue(result, "username"));
        }
        user.setEmail(this.getStringValue(result, "email"));
        return user;
    }

    public boolean checkPassword(String userId, String password) {
        String userName;
        if (StringUtils.isEmpty((Object)userId)) {
            return false;
        }
        if (StringUtils.isEmpty((Object)password)) {
            return false;
        }
        try {
            userName = this.getKeycloakUsername(userId);
        }
        catch (KeycloakUserNotFoundException aunfe) {
            KeycloakPluginLogger.INSTANCE.userNotFound(userId, aunfe);
            return false;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/x-www-form-urlencoded;charset=" + this.keycloakConfiguration.getCharset());
            HttpEntity request = new HttpEntity((Object)("client_id=" + this.keycloakConfiguration.getClientId() + "&client_secret=" + this.keycloakConfiguration.getClientSecret() + "&username=" + userName + "&password=" + URLEncoder.encode(password, this.keycloakConfiguration.getCharset()) + "&grant_type=password"), (MultiValueMap)headers);
            this.restTemplate.postForEntity(this.keycloakConfiguration.getKeycloakIssuerUrl() + "/protocol/openid-connect/token", (Object)request, String.class, new Object[0]);
            return true;
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED)) {
                return false;
            }
            throw new IdentityProviderException("Unable to authenticate user at " + this.keycloakConfiguration.getKeycloakIssuerUrl(), (Throwable)hcee);
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to authenticate user at " + this.keycloakConfiguration.getKeycloakIssuerUrl(), (Throwable)rce);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IdentityProviderException("Unable to authenticate user at " + this.keycloakConfiguration.getKeycloakIssuerUrl(), (Throwable)uee);
        }
    }

    protected String getKeycloakUsername(String userId) throws KeycloakUserNotFoundException, RestClientException {
        if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            return userId;
        }
        try {
            if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
                ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users?email=" + userId, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
                return new JSONArray((String)response.getBody()).getJSONObject(0).getString("username");
            }
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users/" + userId, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            return new JSONObject((String)response.getBody()).getString("username");
        }
        catch (JSONException je) {
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - ID unknown"), je);
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                throw new KeycloakUserNotFoundException(userId + " not found", hcee);
            }
            throw hcee;
        }
    }

    public Group findGroupById(String groupId) {
        return (Group)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult();
    }

    public GroupQuery createGroupQuery() {
        return new KeycloakGroupQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new KeycloakGroupQuery();
    }

    protected long findGroupCountByQueryCriteria(KeycloakGroupQuery groupQuery) {
        return this.findGroupByQueryCriteria(groupQuery).size();
    }

    protected List<Group> findGroupByQueryCriteria(KeycloakGroupQuery groupQuery) {
        if (!StringUtils.isEmpty((Object)groupQuery.getUserId())) {
            return this.requestGroupsByUserId(groupQuery);
        }
        return this.requestGroupsWithoutUserId(groupQuery);
    }

    protected List<Group> requestGroupsByUserId(KeycloakGroupQuery query) {
        String userId = query.getUserId();
        List<Object> groupList = new ArrayList<Group>();
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak group query results: [");
        }
        try {
            String keyCloakID;
            try {
                keyCloakID = this.getKeycloakUserID(userId);
            }
            catch (KeycloakUserNotFoundException e) {
                return groupList;
            }
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users/" + keyCloakID + "/groups", HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read user groups from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JSONArray searchResult = new JSONArray((String)response.getBody());
            for (int i = 0; i < searchResult.length(); ++i) {
                boolean isAuthenticatedUser;
                JSONObject keycloakGroup = searchResult.getJSONObject(i);
                GroupEntity group = this.transformGroup(keycloakGroup);
                if (!this.matches(query.getId(), (Object)group.getId()) || !this.matches(query.getIds(), (Object)group.getId()) || !this.matches(query.getName(), (Object)group.getName()) || !this.matchesLike(query.getNameLike(), group.getName()) || !this.matches(query.getType(), (Object)group.getType()) || !(isAuthenticatedUser = this.isAuthenticatedUser(userId)) && !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.GROUP, group.getId())) continue;
                groupList.add((Group)group);
                if (!KeycloakPluginLogger.INSTANCE.isDebugEnabled()) continue;
                resultLogger.append(group);
                resultLogger.append(" based on ");
                resultLogger.append(keycloakGroup.toString());
                resultLogger.append(", ");
            }
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                return groupList;
            }
            throw hcee;
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to query groups of user " + userId, (Throwable)rce);
        }
        catch (JSONException je) {
            throw new IdentityProviderException("Unable to query groups of user " + userId, (Throwable)je);
        }
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.groupQueryResult(resultLogger.toString());
        }
        if (query.getOrderingProperties().size() > 0) {
            groupList.sort(new GroupComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            groupList = groupList.subList(query.getFirstResult(), Math.min(groupList.size(), query.getFirstResult() + query.getMaxResults()));
        }
        return groupList;
    }

    protected List<Group> requestGroupsWithoutUserId(KeycloakGroupQuery query) {
        List<Object> groupList = new ArrayList<Group>();
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak group query results: [");
        }
        try {
            ResponseEntity response = null;
            if (!StringUtils.isEmpty((Object)query.getId())) {
                response = this.requestGroupById(query.getId());
            } else {
                String groupFilter = this.createGroupSearchFilter(query);
                response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/groups" + groupFilter, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            }
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read groups from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JSONArray searchResult = null;
            searchResult = !StringUtils.isEmpty((Object)query.getId()) ? new JSONArray((String)response.getBody()) : this.flattenSubGroups(new JSONArray((String)response.getBody()), new JSONArray());
            for (int i = 0; i < searchResult.length(); ++i) {
                JSONObject keycloakGroup = searchResult.getJSONObject(i);
                GroupEntity group = this.transformGroup(keycloakGroup);
                if (!this.matches(query.getIds(), (Object)group.getId()) || !this.matches(query.getName(), (Object)group.getName()) || !this.matchesLike(query.getNameLike(), group.getName()) || !this.matches(query.getType(), (Object)group.getType()) || !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.GROUP, group.getId())) continue;
                groupList.add((Group)group);
                if (!KeycloakPluginLogger.INSTANCE.isDebugEnabled()) continue;
                resultLogger.append(group);
                resultLogger.append(" based on ");
                resultLogger.append(keycloakGroup.toString());
                resultLogger.append(", ");
            }
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to query groups", (Throwable)rce);
        }
        catch (JSONException je) {
            throw new IdentityProviderException("Unable to query groups", (Throwable)je);
        }
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.groupQueryResult(resultLogger.toString());
        }
        if (query.getOrderingProperties().size() > 0) {
            groupList.sort(new GroupComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            groupList = groupList.subList(query.getFirstResult(), Math.min(groupList.size(), query.getFirstResult() + query.getMaxResults()));
        }
        return groupList;
    }

    protected String createGroupSearchFilter(KeycloakGroupQuery query) {
        StringBuilder filter = new StringBuilder();
        if (!StringUtils.isEmpty((Object)query.getName())) {
            this.addArgument(filter, "search", query.getName());
        }
        if (!StringUtils.isEmpty((Object)query.getNameLike())) {
            this.addArgument(filter, "search", query.getNameLike().replaceAll("[%,\\*]", ""));
        }
        if (filter.length() > 0) {
            filter.insert(0, "?");
            String result = filter.toString();
            KeycloakPluginLogger.INSTANCE.groupQueryFilter(result);
            return result;
        }
        return "";
    }

    private JSONArray flattenSubGroups(JSONArray groups, JSONArray result) throws JSONException {
        if (groups == null) {
            return result;
        }
        for (int i = 0; i < groups.length(); ++i) {
            JSONObject group = groups.getJSONObject(i);
            try {
                JSONArray subGroups = group.getJSONArray("subGroups");
                group.remove("subGroups");
                result.put(group);
                this.flattenSubGroups(subGroups, result);
                continue;
            }
            catch (JSONException e) {
                result.put(group);
            }
        }
        return result;
    }

    protected ResponseEntity<String> requestGroupById(String groupId) throws RestClientException {
        try {
            String groupSearch = this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId() ? "/group-by-path/" + groupId : "/groups/" + groupId;
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + groupSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            String result = "[" + (String)response.getBody() + "]";
            return new ResponseEntity((Object)result, (MultiValueMap)response.getHeaders(), response.getStatusCode());
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                String result = "[]";
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
            throw hcee;
        }
    }

    protected String getKeycloakGroupID(String groupId) throws KeycloakGroupNotFoundException, RestClientException {
        if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) {
            return groupId;
        }
        String groupSearch = "/group-by-path/" + groupId;
        try {
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + groupSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            return new JSONObject((String)response.getBody()).getString("id");
        }
        catch (JSONException je) {
            throw new KeycloakGroupNotFoundException(groupId + " not found - path unknown", je);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKeycloakAdminGroupId(String configuredAdminGroupName) {
        try {
            ResponseEntity response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/group-by-path/" + configuredAdminGroupName, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) return new JSONObject((String)response.getBody()).getString("id");
            return new JSONObject((String)response.getBody()).getString("path").substring(1);
        }
        catch (JSONException | RestClientException response) {
            try {
                try {
                    ResponseEntity response2 = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/groups?search=" + configuredAdminGroupName, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
                    JSONArray result = this.flattenSubGroups(new JSONArray((String)response2.getBody()), new JSONArray());
                    JSONArray groups = new JSONArray();
                    for (int i = 0; i < result.length(); ++i) {
                        JSONObject keycloakGroup = result.getJSONObject(i);
                        if (!keycloakGroup.getString("name").equals(configuredAdminGroupName)) continue;
                        groups.put(keycloakGroup);
                    }
                    if (groups.length() == 1) {
                        if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) return groups.getJSONObject(0).getString("id");
                        return groups.getJSONObject(0).getString("path").substring(1);
                    }
                    if (groups.length() <= 0) throw new IdentityProviderException("Configured administratorGroupName " + configuredAdminGroupName + " does not exist.");
                    throw new IdentityProviderException("Configured administratorGroupName " + configuredAdminGroupName + " is not unique. Please configure exact group path.");
                }
                catch (JSONException response2) {
                    // empty catch block
                }
                throw new IdentityProviderException("Configured administratorGroupName " + configuredAdminGroupName + " does not exist.");
            }
            catch (RestClientException rce) {
                throw new IdentityProviderException("Unable to read data of configured administratorGroupName " + configuredAdminGroupName, (Throwable)rce);
            }
        }
    }

    protected GroupEntity transformGroup(JSONObject result) throws JSONException {
        GroupEntity group = new GroupEntity();
        if (this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) {
            group.setId(result.getString("path").substring(1));
        } else {
            group.setId(result.getString("id"));
        }
        group.setName(result.getString("name"));
        if (this.isSystemGroup(result)) {
            group.setType("SYSTEM");
        } else {
            group.setType("WORKFLOW");
        }
        return group;
    }

    private boolean isSystemGroup(JSONObject result) {
        String name = result.getString("name");
        if ("camunda-admin".equals(name) || name.equals(this.keycloakConfiguration.getAdministratorGroupName())) {
            return true;
        }
        try {
            JSONArray types = result.getJSONObject("attributes").getJSONArray("type");
            for (int i = 0; i < types.length(); ++i) {
                if (!"SYSTEM".equals(types.getString(i).toUpperCase())) continue;
                return true;
            }
        }
        catch (JSONException ex) {
            return false;
        }
        return false;
    }

    public TenantQuery createTenantQuery() {
        return new KeycloakTenantQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return new KeycloakTenantQuery();
    }

    public Tenant findTenantById(String id) {
        return null;
    }

    protected String getStringValue(JSONObject result, String name) {
        try {
            return result.getString(name);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected void addArgument(StringBuilder filter, String name, String value) {
        if (filter.length() > 0) {
            filter.append("&");
        }
        filter.append(name).append('=').append(value);
    }

    protected boolean matches(Object queryParameter, Object attribute) {
        return queryParameter == null || queryParameter.equals(attribute);
    }

    protected boolean matches(Object[] queryParameter, Object attribute) {
        return queryParameter == null || queryParameter.length == 0 || Arrays.asList(queryParameter).contains(attribute);
    }

    protected boolean matchesLike(String queryParameter, String attribute) {
        return queryParameter == null || attribute.matches(queryParameter.replaceAll("[%\\*]", ".*"));
    }

    protected boolean isAuthenticatedUser(UserEntity user) {
        return this.isAuthenticatedUser(user.getId());
    }

    protected boolean isAuthenticatedUser(String userId) {
        if (userId == null) {
            return false;
        }
        return userId.equalsIgnoreCase(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        return !this.keycloakConfiguration.isAuthorizationCheckEnabled() || Context.getCommandContext().getAuthorizationManager().isAuthorized(permission, resource, resourceId);
    }

    protected static int compare(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    private static class GroupComparator
    implements Comparator<Group> {
        private static final int GROUP_ID = 0;
        private static final int NAME = 1;
        private static final int TYPE = 2;
        private int[] order;
        private boolean[] desc;

        public GroupComparator(List<QueryOrderingProperty> orderList) {
            this.order = new int[orderList.size()];
            this.desc = new boolean[orderList.size()];
            for (int i = 0; i < orderList.size(); ++i) {
                QueryOrderingProperty qop = orderList.get(i);
                this.order[i] = qop.getQueryProperty().equals(GroupQueryProperty.GROUP_ID) ? 0 : (qop.getQueryProperty().equals(GroupQueryProperty.NAME) ? 1 : (qop.getQueryProperty().equals(GroupQueryProperty.TYPE) ? 2 : -1));
                this.desc[i] = Direction.DESCENDING.equals(qop.getDirection());
            }
        }

        @Override
        public int compare(Group g1, Group g2) {
            int c = 0;
            for (int i = 0; i < this.order.length; ++i) {
                switch (this.order[i]) {
                    case 0: {
                        c = KeycloakIdentityProviderSession.compare(g1.getId(), g2.getId());
                        break;
                    }
                    case 1: {
                        c = KeycloakIdentityProviderSession.compare(g1.getName(), g2.getName());
                        break;
                    }
                    case 2: {
                        c = KeycloakIdentityProviderSession.compare(g1.getType(), g2.getType());
                        break;
                    }
                }
                if (c == 0) continue;
                return this.desc[i] ? -c : c;
            }
            return c;
        }
    }

    private static class UserComparator
    implements Comparator<User> {
        private static final int USER_ID = 0;
        private static final int EMAIL = 1;
        private static final int FIRST_NAME = 2;
        private static final int LAST_NAME = 3;
        private int[] order;
        private boolean[] desc;

        public UserComparator(List<QueryOrderingProperty> orderList) {
            this.order = new int[orderList.size()];
            this.desc = new boolean[orderList.size()];
            for (int i = 0; i < orderList.size(); ++i) {
                QueryOrderingProperty qop = orderList.get(i);
                this.order[i] = qop.getQueryProperty().equals(UserQueryProperty.USER_ID) ? 0 : (qop.getQueryProperty().equals(UserQueryProperty.EMAIL) ? 1 : (qop.getQueryProperty().equals(UserQueryProperty.FIRST_NAME) ? 2 : (qop.getQueryProperty().equals(UserQueryProperty.LAST_NAME) ? 3 : -1)));
                this.desc[i] = Direction.DESCENDING.equals(qop.getDirection());
            }
        }

        @Override
        public int compare(User u1, User u2) {
            int c = 0;
            for (int i = 0; i < this.order.length; ++i) {
                switch (this.order[i]) {
                    case 0: {
                        c = KeycloakIdentityProviderSession.compare(u1.getId(), u2.getId());
                        break;
                    }
                    case 1: {
                        c = KeycloakIdentityProviderSession.compare(u1.getEmail(), u2.getEmail());
                        break;
                    }
                    case 2: {
                        c = KeycloakIdentityProviderSession.compare(u1.getFirstName(), u2.getFirstName());
                        break;
                    }
                    case 3: {
                        c = KeycloakIdentityProviderSession.compare(u1.getLastName(), u2.getLastName());
                        break;
                    }
                }
                if (c == 0) continue;
                return this.desc[i] ? -c : c;
            }
            return c;
        }
    }
}

