/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.camunda.bpm.extension.keycloak.cache.CacheConfiguration;
import org.camunda.bpm.extension.keycloak.cache.QueryCache;

public class CaffeineCache<K, V>
implements QueryCache<K, V> {
    private final Cache<K, V> cache;

    public CaffeineCache(CacheConfiguration config) {
        this(config, Ticker.systemTicker());
    }

    public CaffeineCache(CacheConfiguration config, Ticker ticker) {
        this.cache = Caffeine.newBuilder().ticker(ticker).maximumSize((long)config.getMaxSize()).expireAfterWrite(config.getExpirationTimeout()).build();
    }

    @Override
    public V getOrCompute(K key, Function<K, V> computation) {
        return (V)this.cache.get(key, computation);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.cache.asMap();
    }
}

