/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakCheckPasswordCall;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderSession;
import org.camunda.bpm.extension.keycloak.cache.CacheConfiguration;
import org.camunda.bpm.extension.keycloak.cache.CacheFactory;
import org.camunda.bpm.extension.keycloak.cache.QueryCache;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.StringUtils;

public class KeycloakIdentityProviderFactory
implements SessionFactory {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakContextProvider keycloakContextProvider;
    protected QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache;
    protected QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache;
    protected QueryCache<CacheableKeycloakCheckPasswordCall, Boolean> checkPasswordCache;
    protected KeycloakRestTemplate restTemplate = new KeycloakRestTemplate();

    public KeycloakIdentityProviderFactory(KeycloakConfiguration keycloakConfiguration, List<ClientHttpRequestInterceptor> customHttpRequestInterceptors) {
        this.keycloakConfiguration = keycloakConfiguration;
        CacheConfiguration cacheConfiguration = CacheConfiguration.from(keycloakConfiguration);
        CacheConfiguration loginCacheConfiguration = CacheConfiguration.fromLoginConfigOf(keycloakConfiguration);
        this.setUserQueryCache(CacheFactory.create(cacheConfiguration));
        this.setGroupQueryCache(CacheFactory.create(cacheConfiguration));
        this.setCheckPasswordCache(CacheFactory.create(loginCacheConfiguration));
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        if (keycloakConfiguration.isDisableSSLCertificateValidation()) {
            try {
                TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts)).register("http", (Object)new PlainConnectionSocketFactory()).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
                httpClient.setConnectionManager((HttpClientConnectionManager)connectionManager);
            }
            catch (GeneralSecurityException e) {
                throw new IdentityProviderException("Disabling SSL certificate validation failed", (Throwable)e);
            }
        } else {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
            httpClient.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        if (StringUtils.hasLength((String)keycloakConfiguration.getProxyUri())) {
            URI proxyUri = URI.create(keycloakConfiguration.getProxyUri());
            HttpHost proxy = new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme());
            httpClient.setProxy(proxy);
            if (StringUtils.hasLength((String)keycloakConfiguration.getProxyUser()) && keycloakConfiguration.getProxyPassword() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), (Credentials)new UsernamePasswordCredentials(keycloakConfiguration.getProxyUser(), keycloakConfiguration.getProxyPassword()));
                httpClient.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
            }
        }
        factory.setHttpClient((HttpClient)httpClient.build());
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
        for (int i = 0; i < this.restTemplate.getMessageConverters().size(); ++i) {
            if (!(this.restTemplate.getMessageConverters().get(i) instanceof StringHttpMessageConverter)) continue;
            this.restTemplate.getMessageConverters().set(i, new StringHttpMessageConverter(Charset.forName(keycloakConfiguration.getCharset())));
            break;
        }
        this.restTemplate.getInterceptors().addAll(customHttpRequestInterceptors);
        this.keycloakContextProvider = new KeycloakContextProvider(keycloakConfiguration, this.restTemplate);
    }

    public Class<?> getSessionType() {
        return ReadOnlyIdentityProvider.class;
    }

    public void setUserQueryCache(QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache) {
        this.userQueryCache = userQueryCache;
    }

    public void setGroupQueryCache(QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache) {
        this.groupQueryCache = groupQueryCache;
    }

    public void setCheckPasswordCache(QueryCache<CacheableKeycloakCheckPasswordCall, Boolean> checkPasswordCache) {
        this.checkPasswordCache = checkPasswordCache;
    }

    public void clearCache() {
        this.userQueryCache.clear();
        this.groupQueryCache.clear();
        this.checkPasswordCache.clear();
    }

    public Session openSession() {
        return new KeycloakIdentityProviderSession(this.keycloakConfiguration, this.restTemplate, this.keycloakContextProvider, this.userQueryCache, this.groupQueryCache, this.checkPasswordCache);
    }
}

