/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.bdd.steps;

import javax.inject.Inject;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.assertions.ProcessEngineAssertions;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.test.CamundaSupport;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaSteps {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaSteps.class);
    @Inject
    private CamundaSupport support;

    @BeforeStory
    public void init() {
        LOG.debug("Initializing before a story run.");
        ProcessEngineAssertions.init((ProcessEngine)this.support.getProcessEngine());
    }

    @AfterStory(uponGivenStory=false)
    public void cleanUp() {
        LOG.debug("Cleaning up after story run.");
        Mocks.reset();
        this.support.undeploy();
        this.support.resetClock();
        ProcessEngineAssertions.reset();
    }

    @When(value="the process definition $processDefinition")
    @Given(value="the process definition $processDefinition")
    public void deployProcess(String processDefinition) {
        this.support.deploy(processDefinition);
    }

    @When(value="the process $processKey is started")
    public void startProcess(String processKey) {
        this.support.startProcessInstanceByKey(processKey);
    }

    @Then(value="the process is finished")
    public void processIsFinished() {
        ProcessEngineAssertions.assertThat((ProcessInstance)this.support.getProcessInstance()).isEnded();
    }

    @Then(value="the process is finished with event $eventName")
    public void processFinishedSucessfully(String eventName) {
        this.processIsFinished();
        ProcessEngineAssertions.assertThat((ProcessInstance)this.support.getProcessInstance()).hasPassed(new String[]{eventName});
    }

    @Then(value="the step $activityId is reached")
    @When(value="the step $activityId is reached")
    public void stepIsReached(String activityId) {
        ProcessEngineAssertions.assertThat((ProcessInstance)this.support.getProcessInstance()).isWaitingAt(new String[]{activityId});
        LOG.debug("Step {} reached.", (Object)activityId);
    }
}

