/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.camunda.bpm.data.Guard;
import org.camunda.bpm.engine.delegate.DelegateExecution;

public final class Guards {
    public static final String VARIABLE_SKIP_GUARDS = "runtimeSkipGuards";
    public static final Map<String, Object> MAP_SKIP_GUARDS = new HashMap<String, Object>();
    private static final String VARIABLE_NAME_MUST_BE_NOT_NULL = "Variable name must be not null";
    private static final Predicate<String> isPrecondition = Predicates.or((Predicate)Predicates.equalTo((Object)"start"), (Predicate)Predicates.equalTo((Object)"create"));
    private static final Predicate<String> isPostcondition = Predicates.or((Predicate)Predicates.equalTo((Object)"end"), (Predicate)Predicates.equalTo((Object)"complete"));

    public static void dispatch(Guard guard, String eventName, DelegateExecution execution) {
        if (Guards.skipGuards(execution)) {
            return;
        }
        if (isPrecondition.apply((Object)eventName)) {
            guard.checkPreconditions(execution);
        } else if (isPostcondition.apply((Object)eventName)) {
            guard.checkPostconditions(execution);
        }
    }

    public static boolean skipGuards(DelegateExecution execution) {
        return BooleanUtils.toBoolean((Boolean)((Boolean)execution.getVariable(VARIABLE_SKIP_GUARDS)));
    }

    public static void checkIsSetLocal(DelegateExecution execution, String variableName) {
        Preconditions.checkArgument((variableName != null ? 1 : 0) != 0, (Object)VARIABLE_NAME_MUST_BE_NOT_NULL);
        Object variableLocal = execution.getVariableLocal(variableName);
        Preconditions.checkState((variableLocal != null ? 1 : 0) != 0, (Object)String.format("Condition of task '%s' is violated: Local variable '%s' is not set.", execution.getCurrentActivityId(), variableName));
    }

    public static void checkIsSet(DelegateExecution execution, String variableName) {
        Preconditions.checkArgument((variableName != null ? 1 : 0) != 0, (Object)VARIABLE_NAME_MUST_BE_NOT_NULL);
        Object variableLocal = execution.getVariableLocal(variableName);
        Object variable = execution.getVariable(variableName);
        Preconditions.checkState((variableLocal != null || variable != null ? 1 : 0) != 0, (Object)String.format("Condition of task '%s' is violated: Variable '%s' is not set.", execution.getCurrentActivityId(), variableName));
    }

    public static void checkIsSetGlobal(DelegateExecution execution, String variableName) {
        Preconditions.checkArgument((variableName != null ? 1 : 0) != 0, (Object)VARIABLE_SKIP_GUARDS);
        Object variable = execution.getVariable(variableName);
        Preconditions.checkState((variable != null ? 1 : 0) != 0, (Object)String.format("Condition of task '%s' is violated: Global variable '%s' is not set.", execution.getCurrentActivityId(), variableName));
    }
}

