/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.cfg.MostUsefulProcessEngineConfiguration;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.needle4j.injection.InjectionProvider;
import org.needle4j.injection.InjectionProviders;
import org.needle4j.injection.InjectionTargetInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaSupport
implements InjectionProvider<CamundaSupport> {
    private final Logger logger = LoggerFactory.getLogger(CamundaSupport.class);
    private final InjectionProvider<CamundaSupport> injectionProviderDelegate = InjectionProviders.providerForInstance((Object)this);
    private final Set<String> deploymentIds = Sets.newHashSet();
    private ProcessEngine processEngine;
    private ProcessInstance processInstance;
    private Date startTime;

    public CamundaSupport() {
        this(MostUsefulProcessEngineConfiguration.mostUsefulProcessEngineConfiguration().buildProcessEngine());
    }

    public CamundaSupport(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.logger.debug("Camunda Support created.");
    }

    public void deploy(String ... processModelResources) {
        DeploymentBuilder deploymentBuilder = this.processEngine.getRepositoryService().createDeployment();
        for (String resource : processModelResources) {
            deploymentBuilder.addClasspathResource(resource);
        }
        this.deploymentIds.add(deploymentBuilder.deploy().getId());
        this.getStartTime();
    }

    public void undeploy() {
        for (String deploymentId : this.deploymentIds) {
            this.processEngine.getRepositoryService().deleteDeployment(deploymentId, true);
        }
        Mocks.reset();
    }

    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, Object> variables) {
        Preconditions.checkArgument((processDefinitionKey != null ? 1 : 0) != 0, (Object)"processDefinitionKey must not be null!");
        this.processInstance = this.processEngine.getRuntimeService().startProcessInstanceByKey(processDefinitionKey, variables);
        return this.processInstance;
    }

    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey) {
        return this.startProcessInstanceByKey(processDefinitionKey, null);
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime((Date)currentTime);
    }

    public void resetClock() {
        ClockUtil.reset();
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        return this.startTime;
    }

    public static boolean parseStatement(String negation, String value, boolean defaultValue) {
        return value != null ? !value.contains(negation) : defaultValue;
    }

    public boolean hasRunningProcessInstance() {
        return this.getProcessInstance() != null;
    }

    public CamundaSupport getInjectedObject(Class<?> injectionPointType) {
        return (CamundaSupport)this.injectionProviderDelegate.getInjectedObject(injectionPointType);
    }

    public Object getKey(InjectionTargetInformation injectionTargetInformation) {
        return this.injectionProviderDelegate.getKey(injectionTargetInformation);
    }

    public boolean verify(InjectionTargetInformation injectionTargetInformation) {
        return this.injectionProviderDelegate.verify(injectionTargetInformation);
    }
}

