/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.junit5.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEngineExtension
implements TestWatcher,
TestInstancePostProcessor,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessEngineExtension.class);
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected String configurationResource = "camunda.cfg.xml";
    private String deploymentId;
    public static final List<String> RESOURCE_SUFFIXES = new ArrayList<String>();

    private static Supplier<IllegalStateException> illegalStateException(String msg) {
        return () -> new IllegalStateException(msg);
    }

    public static ProcessEngineExtension builder() {
        return new ProcessEngineExtension();
    }

    public ProcessEngineExtension configurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
        return this;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.getType() == ProcessEngine.class).forEach(field -> this.inject(testInstance, (Field)field));
    }

    protected void initializeProcessEngine() {
        this.processEngine = TestHelper.getProcessEngine((String)this.configurationResource);
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
    }

    private void inject(Object instance, Field field) {
        field.setAccessible(true);
        try {
            field.set(instance, this.processEngine);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void beforeTestExecution(ExtensionContext context) {
        LOG.debug("beforeTestExecution: {}", (Object)context.getDisplayName());
        Method testMethod = (Method)context.getTestMethod().orElseThrow(ProcessEngineExtension.illegalStateException("testMethod not set"));
        Class testClass = (Class)context.getTestClass().orElseThrow(ProcessEngineExtension.illegalStateException("testClass not set"));
        this.doDeployment(testMethod, testClass);
        this.checkRequiredHistoryLevel(testMethod);
    }

    private void doDeployment(Method testMethod, Class<?> testClass) {
        DeploymentBuilder deploymentBuilder = this.processEngine.getRepositoryService().createDeployment().name(testClass.getSimpleName() + "." + testMethod.getName());
        Deployment methodAnnotation = testMethod.getAnnotation(Deployment.class);
        if (methodAnnotation != null) {
            this.getDeploymentResources(testClass, testMethod.getName(), methodAnnotation, deploymentBuilder);
            LOG.info("annotation @Deployment creates deployment for {}.{}", (Object)testClass.getName(), (Object)testMethod.getName());
            this.deploymentId = deploymentBuilder.deploy().getId();
        } else {
            Deployment classAnnotation = testClass.getAnnotation(Deployment.class);
            if (classAnnotation != null) {
                this.getDeploymentResources(testClass, null, classAnnotation, deploymentBuilder);
                LOG.info("annotation @Deployment creates deployment for {}.{}", (Object)testClass.getName(), (Object)testMethod.getName());
                this.deploymentId = deploymentBuilder.deploy().getId();
            } else {
                Class<?> lookForAnnotationClass;
                for (lookForAnnotationClass = testClass.getSuperclass(); lookForAnnotationClass != Object.class && (classAnnotation = lookForAnnotationClass.getAnnotation(Deployment.class)) == null; lookForAnnotationClass = lookForAnnotationClass.getSuperclass()) {
                }
                if (classAnnotation != null) {
                    this.getDeploymentResources(lookForAnnotationClass, null, classAnnotation, deploymentBuilder);
                    LOG.info("annotation @Deployment creates deployment for {}.{}", (Object)testClass.getName(), (Object)testMethod.getName());
                    this.deploymentId = deploymentBuilder.deploy().getId();
                }
            }
        }
    }

    private void getDeploymentResources(Class<?> testClass, String testMethodName, Deployment annotation, DeploymentBuilder deploymentBuilder) {
        String[] resources = annotation.resources();
        if (resources.length == 0) {
            deploymentBuilder.addClasspathResource(TestHelper.getBpmnProcessDefinitionResource(testClass, (String)testMethodName));
        } else {
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
        }
    }

    private void checkRequiredHistoryLevel(Method testMethod) {
        RequiredHistoryLevel annotation = testMethod.getAnnotation(RequiredHistoryLevel.class);
        if (annotation != null) {
            HistoryLevel currentHistoryLevel = this.getProcessEngineConfiguration().getHistoryLevel();
            String requiredHistoryLevelName = annotation.value();
            int requiredHistoryLevel = 0;
            for (HistoryLevel level : this.getProcessEngineConfiguration().getHistoryLevels()) {
                if (!level.getName().equalsIgnoreCase(requiredHistoryLevelName)) continue;
                requiredHistoryLevel = level.getId();
            }
            Assumptions.assumeTrue((currentHistoryLevel.getId() >= requiredHistoryLevel ? 1 : 0) != 0, (String)"ignored because the current history level is too low");
        }
    }

    public void afterTestExecution(ExtensionContext context) {
        Method testMethod = (Method)context.getTestMethod().orElseThrow(ProcessEngineExtension.illegalStateException("testMethod not set"));
        Class testClass = (Class)context.getTestClass().orElseThrow(ProcessEngineExtension.illegalStateException("testClass not set"));
        if (this.deploymentId != null) {
            LOG.info("annotation @Deployment deletes deployment for {}.{}", (Object)testClass.getName(), (Object)testMethod.getName());
            this.processEngine.getRepositoryService().deleteDeployment(this.deploymentId, true, true, true);
            this.deploymentId = null;
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(ProcessEngine.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (ProcessEngine.class.equals(parameterContext.getParameter().getType())) {
            LOG.debug("resolve the processEngine as parameter");
            return this.getProcessEngine();
        }
        return null;
    }

    public ProcessEngineExtension build() {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        return this;
    }

    static {
        RESOURCE_SUFFIXES.addAll(Arrays.asList(BpmnDeployer.BPMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(CmmnDeployer.CMMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(DecisionDefinitionDeployer.DMN_RESOURCE_SUFFIXES));
    }
}

