/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesMailConfiguration
implements MailConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesMailConfiguration.class);
    public static final String ENV_PROPERTIES_PATH = "MAIL_CONFIG";
    public static final String PROPERTIES_CLASSPATH_PREFIX = "classpath:";
    public static final String DEFAULT_PROPERTIES_PATH = "classpath:/mail-config.properties";
    public static final String PROPERTY_USER = "mail.user";
    public static final String PROPERTY_PASSWORD = "mail.password";
    public static final String PROPERTY_POLL_FOLDER = "mail.poll.folder";
    public static final String PROPERTY_SENDER = "mail.sender";
    public static final String PROPERTY_SENDER_ALIAS = "mail.sender.alias";
    public static final String PROPERTY_ATTACHMENT_DOWNLOAD = "mail.attachment.download";
    public static final String PROPERTY_ATTACHMENT_PATH = "mail.attachment.path";
    public static final String DEFAULT_ATTACHMENT_PATH = "attachments";
    public static final String PROPERTY_NOTIFICATION_LOOKUP_TIME = "mail.notification.lookup.time";
    public static final String DEFAULT_NOTIFICATION_LOOKUP_TIME = Duration.ofSeconds(60L).toString();
    protected Properties properties = null;
    protected String path = null;

    public PropertiesMailConfiguration() {
    }

    public PropertiesMailConfiguration(String path) {
        this.path = path;
    }

    public PropertiesMailConfiguration(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String getUserName() {
        return this.getProperties().getProperty(PROPERTY_USER);
    }

    @Override
    public String getPassword() {
        return this.getProperties().getProperty(PROPERTY_PASSWORD);
    }

    @Override
    public String getPollFolder() {
        return this.getProperties().getProperty(PROPERTY_POLL_FOLDER);
    }

    @Override
    public String getSender() {
        return this.getProperties().getProperty(PROPERTY_SENDER);
    }

    @Override
    public String getSenderAlias() {
        return this.getProperties().getProperty(PROPERTY_SENDER_ALIAS);
    }

    @Override
    public boolean downloadAttachments() {
        String downloadAttachments = this.getProperties().getProperty(PROPERTY_ATTACHMENT_DOWNLOAD);
        return Boolean.parseBoolean(downloadAttachments);
    }

    @Override
    public String getAttachmentPath() {
        return this.getProperties().getProperty(PROPERTY_ATTACHMENT_PATH, DEFAULT_ATTACHMENT_PATH);
    }

    @Override
    public Duration getNotificationLookupTime() {
        String looukupTime = this.getProperties().getProperty(PROPERTY_NOTIFICATION_LOOKUP_TIME, DEFAULT_NOTIFICATION_LOOKUP_TIME);
        return Duration.parse(looukupTime);
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    protected Properties loadProperties() {
        Properties properties = new Properties();
        String path = this.getPropertiesPath();
        try {
            InputStream inputStream = this.getProperiesAsStream(path);
            if (inputStream != null) {
                properties.load(inputStream);
                return properties;
            }
            throw new IllegalStateException("Cannot find mail configuration at: " + path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load mail configuration from: " + path, e);
        }
    }

    protected String getPropertiesPath() {
        return Optional.ofNullable(this.path).orElseGet(() -> Optional.ofNullable(System.getenv(ENV_PROPERTIES_PATH)).orElse(DEFAULT_PROPERTIES_PATH));
    }

    protected InputStream getProperiesAsStream(String path) throws FileNotFoundException {
        if (path.startsWith(PROPERTIES_CLASSPATH_PREFIX)) {
            String pathWithoutPrefix = path.substring(PROPERTIES_CLASSPATH_PREFIX.length());
            LOGGER.debug("load mail properties from classpath '{}'", (Object)pathWithoutPrefix);
            return this.getClass().getResourceAsStream(pathWithoutPrefix);
        }
        Path config = Paths.get(path, new String[0]);
        LOGGER.debug("load mail properties from path '{}'", (Object)config.toAbsolutePath());
        File file = config.toFile();
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }
}

