/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.delete;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.extension.mail.EmptyResponse;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.connect.impl.AbstractConnectorRequest;
import org.camunda.connect.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteMailRequest
extends AbstractConnectorRequest<EmptyResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteMailRequest.class);
    protected static final String PARAM_FOLDER = "folder";
    protected static final String PARAM_MAILS = "mails";
    protected static final String PARAM_MESSAGE_IDS = "messageIds";
    protected static final String PARAM_MESSAGE_NUMBERS = "messageNumbers";
    protected final MailConfiguration configuration;

    public DeleteMailRequest(Connector<?> connector, MailConfiguration configuration) {
        super(connector);
        this.configuration = configuration;
    }

    public String getFolder() {
        String folder = (String)this.getRequestParameter(PARAM_FOLDER);
        if (folder == null) {
            folder = this.configuration.getPollFolder();
        }
        return folder;
    }

    public DeleteMailRequest folder(String folder) {
        this.setRequestParameter(PARAM_FOLDER, folder);
        return this;
    }

    public List<Mail> getMails() {
        return (List)this.getRequestParameter(PARAM_MAILS);
    }

    public DeleteMailRequest mails(Mail ... mails) {
        this.setRequestParameter(PARAM_MAILS, Arrays.asList(mails));
        return this;
    }

    public List<String> getMessageIds() {
        return (List)this.getRequestParameter(PARAM_MESSAGE_IDS);
    }

    public DeleteMailRequest messageIds(String ... messageIds) {
        this.setRequestParameter(PARAM_MESSAGE_IDS, Arrays.asList(messageIds));
        return this;
    }

    public List<Integer> getMessageNumbers() {
        return (List)this.getRequestParameter(PARAM_MESSAGE_NUMBERS);
    }

    public DeleteMailRequest messageNumbers(Integer ... messageNumbers) {
        this.setRequestParameter(PARAM_MESSAGE_NUMBERS, Arrays.asList(messageNumbers));
        return this;
    }

    protected boolean isRequestValid() {
        if (this.getFolder() == null || this.getFolder().isEmpty()) {
            LOGGER.warn("invalid request: missing parameter 'folder' in {}", (Object)this);
            return false;
        }
        if (!(this.hasMails() || this.hasMessageIds() || this.hasMessageNumbers())) {
            LOGGER.warn("invalid request: either parameter 'mails', 'messageIds' or 'messageNumbers' must be set in {}", (Object)this);
            return false;
        }
        return true;
    }

    protected boolean hasMails() {
        return this.getMails() != null && !this.getMails().isEmpty();
    }

    protected boolean hasMessageIds() {
        return this.getMessageIds() != null && !this.getMessageIds().isEmpty();
    }

    protected boolean hasMessageNumbers() {
        return this.getMessageNumbers() != null && !this.getMessageNumbers().isEmpty();
    }

    public String toString() {
        return "DeleteMailRequest [folder=" + this.getFolder() + ", mails=" + this.getMails() + ", message-ids=" + this.getMessageIds() + ", message-numbers=" + this.getMessageNumbers() + "]";
    }
}

