/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.dto;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.Part;

public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private String path;
    private transient Part part;

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public Path download(Path downloadPath) throws MessagingException, IOException {
        Path newFile = downloadPath.resolve(this.fileName);
        DataHandler dataHandler = this.part.getDataHandler();
        Files.copy(dataHandler.getInputStream(), newFile, new CopyOption[0]);
        this.path = newFile.toAbsolutePath().toString();
        return newFile;
    }

    public String toString() {
        return "Attachment [fileName=" + this.fileName + ", path=" + this.path + "]";
    }

    public static Attachment from(Part part) throws MessagingException {
        Attachment attachment = new Attachment();
        attachment.fileName = part.getFileName();
        attachment.part = part;
        return attachment;
    }
}

