/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import javax.mail.MessagingException;
import org.camunda.bpm.extension.mail.notification.NotificationWorker;
import org.camunda.bpm.extension.mail.service.MailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleNotificationWorker
implements NotificationWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleNotificationWorker.class);
    protected final MailService mailService;
    protected final IMAPFolder folder;
    protected boolean runnning = true;

    public IdleNotificationWorker(MailService mailService, IMAPFolder folder) {
        this.mailService = mailService;
        this.folder = folder;
    }

    @Override
    public void run() {
        while (this.runnning) {
            this.waitingForMails();
        }
    }

    protected void waitingForMails() {
        try {
            this.mailService.ensureOpenFolder(this.folder);
            LOGGER.debug("waiting for mails");
            this.folder.idle();
        }
        catch (Exception e) {
            LOGGER.debug("exception while waiting for mails", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.runnning = false;
        try {
            this.folder.doCommand(new IMAPFolder.ProtocolCommand(){

                @Override
                public Object doCommand(IMAPProtocol p) throws ProtocolException {
                    p.simpleCommand("NOOP", null);
                    return null;
                }
            });
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public String toString() {
        return "IdleNotificationWorker [folder=" + this.folder.getName() + ", runnning=" + this.runnning + "]";
    }
}

