/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.notification.IdleNotificationWorker;
import org.camunda.bpm.extension.mail.notification.MessageHandler;
import org.camunda.bpm.extension.mail.notification.MessageTransformationHandler;
import org.camunda.bpm.extension.mail.notification.NotificationWorker;
import org.camunda.bpm.extension.mail.notification.PollNotificationWorker;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.bpm.extension.mail.service.MailServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailNotificationService.class);
    protected final MailService mailService;
    protected final MailConfiguration configuration;
    protected final List<MessageHandler> handlers = new LinkedList<MessageHandler>();
    protected ExecutorService executorService = null;
    protected NotificationWorker notificationWorker;

    public MailNotificationService(MailConfiguration configuration) {
        this.configuration = configuration;
        this.mailService = MailServiceFactory.getService(configuration);
    }

    public void start() throws Exception {
        this.start(this.configuration.getPollFolder());
    }

    public void start(String folderName) throws Exception {
        this.executorService = Executors.newSingleThreadExecutor();
        Folder folder = this.mailService.ensureOpenFolder(folderName);
        folder.addMessageCountListener(new MessageCountAdapter(){

            @Override
            public void messagesAdded(MessageCountEvent event) {
                List<Message> messages = Arrays.asList(event.getMessages());
                MailNotificationService.this.handlers.forEach(handler -> handler.accept(messages));
            }
        });
        this.notificationWorker = this.supportsIdle(folder) ? new IdleNotificationWorker(this.mailService, (IMAPFolder)folder) : new PollNotificationWorker(this.mailService, folder, this.configuration.getNotificationLookupTime());
        LOGGER.debug("start notification service: {}", (Object)this.notificationWorker);
        this.executorService.submit(this.notificationWorker);
    }

    public void stop() {
        if (this.notificationWorker != null) {
            LOGGER.debug("stop notification service");
            this.notificationWorker.stop();
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    protected boolean supportsIdle(Folder folder) throws MessagingException {
        Store store = folder.getStore();
        if (store instanceof IMAPStore) {
            IMAPStore imapStore = (IMAPStore)store;
            return imapStore.hasCapability("IDLE") && folder instanceof IMAPFolder;
        }
        return false;
    }

    public void registerMessageHandler(MessageHandler handler) {
        this.handlers.add(handler);
    }

    public void registerMailHandler(Consumer<Mail> consumer) {
        MessageTransformationHandler handler = new MessageTransformationHandler(consumer, this.configuration.downloadAttachments(), this.configuration.getAttachmentPath());
        this.registerMessageHandler(handler);
    }
}

