/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import java.time.Duration;
import javax.mail.Folder;
import org.camunda.bpm.extension.mail.notification.NotificationWorker;
import org.camunda.bpm.extension.mail.service.MailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollNotificationWorker
implements NotificationWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollNotificationWorker.class);
    protected final MailService mailService;
    protected final Folder folder;
    protected final Duration lookupTime;
    protected boolean running = true;

    public PollNotificationWorker(MailService mailService, Folder folder, Duration lookupTime) {
        this.mailService = mailService;
        this.folder = folder;
        this.lookupTime = lookupTime;
    }

    @Override
    public void run() {
        while (this.running) {
            this.triggerMailServer();
            this.waitTillNextLookup();
        }
    }

    protected void triggerMailServer() {
        try {
            LOGGER.debug("trigger the mail server");
            this.mailService.ensureOpenFolder(this.folder);
            this.folder.getMessageCount();
        }
        catch (Exception e) {
            LOGGER.debug("exception while triggering mail server", (Throwable)e);
        }
    }

    protected void waitTillNextLookup() {
        try {
            Thread.sleep(this.lookupTime.toMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.running = false;
        PollNotificationWorker pollNotificationWorker = this;
        synchronized (pollNotificationWorker) {
            this.notifyAll();
        }
    }

    public String toString() {
        return "PollNotificationWorker [folder=" + this.folder.getName() + ", lookupTime=" + this.lookupTime + ", running=" + this.running + "]";
    }
}

