/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.poll;

import java.util.List;
import javax.mail.Folder;
import org.camunda.bpm.extension.mail.MailConnectorException;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.config.MailConfigurationFactory;
import org.camunda.bpm.extension.mail.poll.PollMailInvocation;
import org.camunda.bpm.extension.mail.poll.PollMailRequest;
import org.camunda.bpm.extension.mail.poll.PollMailResponse;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.bpm.extension.mail.service.MailServiceFactory;
import org.camunda.connect.impl.AbstractConnector;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollMailConnector
extends AbstractConnector<PollMailRequest, PollMailResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollMailConnector.class);
    public static final String CONNECTOR_ID = "mail-poll";
    protected MailConfiguration configuration;

    public PollMailConnector() {
        super(CONNECTOR_ID);
    }

    public PollMailRequest createRequest() {
        return new PollMailRequest((Connector<?>)this, this.getConfiguration());
    }

    public ConnectorResponse execute(PollMailRequest request) {
        MailService mailService = MailServiceFactory.getService(this.getConfiguration());
        try {
            Folder folder = mailService.ensureOpenFolder(request.getFolder());
            PollMailInvocation invocation = new PollMailInvocation(folder, request, this.requestInterceptors, mailService);
            List messages = (List)invocation.proceed();
            LOGGER.debug("poll {} mails from folder '{}'", (Object)messages.size(), (Object)folder.getName());
            return new PollMailResponse(messages, mailService, request.downloadAttachments(), this.getConfiguration().getAttachmentPath());
        }
        catch (Exception e) {
            throw new MailConnectorException("Failed to poll mails: " + e.getMessage(), e);
        }
    }

    protected MailConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = MailConfigurationFactory.getConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }
}

