/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.poll;

import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.poll.PollMailResponse;
import org.camunda.connect.impl.AbstractConnectorRequest;
import org.camunda.connect.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollMailRequest
extends AbstractConnectorRequest<PollMailResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollMailRequest.class);
    protected static final String PARAM_FOLDER = "folder";
    protected static final String PARAM_DOWNLOAD_ATTACHMENTS = "download-attachements";
    protected final MailConfiguration configuration;

    public PollMailRequest(Connector<?> connector, MailConfiguration configuration) {
        super(connector);
        this.configuration = configuration;
    }

    public String getFolder() {
        String folder = (String)this.getRequestParameter(PARAM_FOLDER);
        if (folder == null) {
            folder = this.configuration.getPollFolder();
        }
        return folder;
    }

    public PollMailRequest folder(String folder) {
        this.setRequestParameter(PARAM_FOLDER, folder);
        return this;
    }

    public boolean downloadAttachments() {
        Boolean downloadAttachments = (Boolean)this.getRequestParameter(PARAM_DOWNLOAD_ATTACHMENTS);
        if (downloadAttachments == null) {
            downloadAttachments = this.configuration.downloadAttachments();
        }
        return downloadAttachments;
    }

    public PollMailRequest downloadAttachments(boolean downloadAttachments) {
        this.setRequestParameter(PARAM_DOWNLOAD_ATTACHMENTS, downloadAttachments);
        return this;
    }

    protected boolean isRequestValid() {
        if (this.getFolder() == null || this.getFolder().isEmpty()) {
            LOGGER.warn("invalid request: missing parameter 'folder' in {}", (Object)this);
            return false;
        }
        return true;
    }

    public String toString() {
        return "PollMailRequest [folder=" + this.getFolder() + ", download-attachments=" + this.downloadAttachments() + "]";
    }
}

