/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.poll;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Message;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.connect.impl.AbstractConnectorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollMailResponse
extends AbstractConnectorResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollMailResponse.class);
    public static final String PARAM_MAILS = "mails";
    protected final List<Message> messages;
    protected final MailService mailService;
    protected final boolean downloadAttachments;
    protected final String attachmentPath;

    public PollMailResponse(List<Message> messages, MailService mailService, boolean downloadAttachments, String attachmentPath) {
        this.messages = messages;
        this.mailService = mailService;
        this.downloadAttachments = downloadAttachments;
        this.attachmentPath = attachmentPath;
    }

    protected void collectResponseParameters(Map<String, Object> responseParameters) {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        for (Message message : this.messages) {
            try {
                Mail mail = Mail.from(message);
                if (this.downloadAttachments) {
                    mail.downloadAttachments(this.attachmentPath);
                }
                mails.add(mail);
            }
            catch (Exception e) {
                LOGGER.error("exception while transforming message to dto", (Throwable)e);
            }
        }
        responseParameters.put(PARAM_MAILS, mails);
        this.mailService.flush();
    }

    public List<Mail> getMails() {
        return (List)this.getResponseParameter(PARAM_MAILS);
    }

    public String toString() {
        return "PollMailResponse [messages=" + this.messages + "]";
    }
}

