/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.send;

import java.io.IOException;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.camunda.bpm.extension.mail.EmptyResponse;
import org.camunda.bpm.extension.mail.MailConnectorException;
import org.camunda.bpm.extension.mail.MailContentType;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.config.MailConfigurationFactory;
import org.camunda.bpm.extension.mail.send.SendMailInvocation;
import org.camunda.bpm.extension.mail.send.SendMailRequest;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.bpm.extension.mail.service.MailServiceFactory;
import org.camunda.connect.impl.AbstractConnector;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorResponse;

public class SendMailConnector
extends AbstractConnector<SendMailRequest, EmptyResponse> {
    public static final String CONNECTOR_ID = "mail-send";
    protected MailConfiguration configuration;

    public SendMailConnector() {
        super(CONNECTOR_ID);
    }

    public SendMailRequest createRequest() {
        return new SendMailRequest((Connector<?>)this, this.getConfiguration());
    }

    public ConnectorResponse execute(SendMailRequest request) {
        MailService mailService = MailServiceFactory.getService(this.getConfiguration());
        try {
            Message message = this.createMessage(request, mailService.getSession());
            SendMailInvocation invocation = new SendMailInvocation(message, request, this.requestInterceptors, mailService);
            invocation.proceed();
        }
        catch (Exception e) {
            throw new MailConnectorException("Failed to send mail: " + e.getMessage(), e);
        }
        return new EmptyResponse();
    }

    protected Message createMessage(SendMailRequest request, Session session) throws Exception {
        MimeMessage message = new MimeMessage(session);
        ((Message)message).setFrom(new InternetAddress(request.getFrom(), request.getFromAlias()));
        ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(request.getTo()));
        if (request.getCc() != null) {
            ((Message)message).setRecipients(Message.RecipientType.CC, InternetAddress.parse(request.getCc()));
        }
        if (request.getBcc() != null) {
            ((Message)message).setRecipients(Message.RecipientType.BCC, InternetAddress.parse(request.getBcc()));
        }
        ((Message)message).setSentDate(new Date());
        ((Message)message).setSubject(request.getSubject());
        if (this.hasContent(request)) {
            this.createMessageContent(message, request);
        } else {
            message.setText("");
        }
        return message;
    }

    protected boolean hasContent(SendMailRequest request) {
        return request.getText() != null || request.getHtml() != null || request.getFileNames() != null && !request.getFileNames().isEmpty();
    }

    protected void createMessageContent(Message message, SendMailRequest request) throws MessagingException, IOException {
        if (this.isTextOnlyMessage(request)) {
            message.setText(request.getText());
        } else {
            MimeMultipart multiPart = new MimeMultipart();
            if (request.getText() != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(request.getText());
                ((Multipart)multiPart).addBodyPart(textPart);
            }
            if (request.getHtml() != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent(request.getHtml(), MailContentType.TEXT_HTML.getType());
                ((Multipart)multiPart).addBodyPart(htmlPart);
            }
            if (request.getFileNames() != null) {
                for (String fileName : request.getFileNames()) {
                    MimeBodyPart part = new MimeBodyPart();
                    part.attachFile(fileName);
                    ((Multipart)multiPart).addBodyPart(part);
                }
            }
            message.setContent(multiPart);
        }
    }

    protected boolean isTextOnlyMessage(SendMailRequest request) {
        return request.getHtml() == null && request.getFileNames() == null;
    }

    protected MailConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = MailConfigurationFactory.getConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }
}

