/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.send;

import java.util.List;
import javax.mail.Message;
import javax.mail.Transport;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.send.SendMailRequest;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.connect.impl.AbstractRequestInvocation;
import org.camunda.connect.spi.ConnectorRequest;
import org.camunda.connect.spi.ConnectorRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailInvocation
extends AbstractRequestInvocation<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMailInvocation.class);
    protected final MailService mailService;

    public SendMailInvocation(Message message, SendMailRequest request, List<ConnectorRequestInterceptor> requestInterceptors, MailService mailService) {
        super((Object)message, (ConnectorRequest)request, requestInterceptors);
        this.mailService = mailService;
    }

    public Object invokeTarget() throws Exception {
        Message message = (Message)this.target;
        LOGGER.debug("send '{}'", (Object)Mail.from(message));
        Transport transport = this.mailService.getTransport();
        transport.sendMessage(message, message.getAllRecipients());
        this.mailService.flush();
        return null;
    }
}

