/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.service;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailService.class);
    private static Session session = null;
    private static Store store = null;
    private final MailConfiguration configuration;

    public MailService(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public Session getSession() {
        if (session == null) {
            LOGGER.debug("open session");
            Properties props = this.configuration.getProperties();
            session = Session.getInstance(props);
        }
        return session;
    }

    public Folder ensureOpenFolder(String folderName) throws MessagingException {
        if (store == null) {
            store = this.getSession().getStore();
        }
        this.ensureConnectedStore(store);
        Folder folder = store.getFolder(folderName);
        return this.ensureOpenFolder(folder);
    }

    public Folder ensureOpenFolder(Folder folder) throws MessagingException {
        this.ensureConnectedStore(folder.getStore());
        if (!folder.isOpen()) {
            this.openFolder(folder);
        }
        return folder;
    }

    private void ensureConnectedStore(Store store) throws MessagingException {
        if (!store.isConnected()) {
            LOGGER.debug("connect to sore");
            store.connect(this.configuration.getUserName(), this.configuration.getPassword());
        }
    }

    private void openFolder(Folder folder) throws MessagingException {
        LOGGER.debug("open folder '{}'", (Object)folder.getName());
        folder.open(2);
        if (!folder.isOpen()) {
            throw new IllegalStateException("folder is not open");
        }
    }

    public Transport getTransport() throws IOException, MessagingException {
        Transport transport = this.getSession().getTransport();
        if (!transport.isConnected()) {
            LOGGER.debug("connect transport");
            transport.connect(this.configuration.getUserName(), this.configuration.getPassword());
        }
        return transport;
    }

    public void close() throws Exception {
        if (store != null) {
            LOGGER.debug("close the store");
            store.close();
            store = null;
        }
    }

    public void flush() {
        if (store != null) {
            LOGGER.debug("flush by closing the store");
            try {
                store.close();
            }
            catch (MessagingException e) {
                LOGGER.warn("Failure while closing store", (Throwable)e);
            }
        }
    }
}

