/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.notification.IdleNotificationWorker;
import org.camunda.bpm.extension.mail.notification.MessageHandler;
import org.camunda.bpm.extension.mail.notification.MessageTransformationHandler;
import org.camunda.bpm.extension.mail.notification.NotificationWorker;
import org.camunda.bpm.extension.mail.notification.PollNotificationWorker;
import org.camunda.bpm.extension.mail.service.FolderWrapper;
import org.camunda.bpm.extension.mail.service.MailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailNotificationService.class);
    private final MailService mailService;
    private final MailConfiguration configuration;
    private final Set<MessageHandler> messageHandlers = new HashSet<MessageHandler>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Future<?> completion;
    private NotificationWorker notificationWorker;

    public MailNotificationService(MailConfiguration configuration, MailService mailService) {
        this.configuration = configuration;
        this.mailService = mailService;
    }

    public void start() {
        if (!this.running.get()) {
            this.running.set(true);
            try {
                this.doStart();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doStart() {
        this.notificationWorker = this.getNotificationWorker();
        this.completion = this.executorService.submit(() -> {
            while (this.running.get()) {
                try {
                    FolderWrapper folder = this.mailService.getFolder(this.configuration.getPollFolder());
                    Throwable throwable = null;
                    try {
                        folder.getFolder().addMessageCountListener(new MessageCountAdapter(){

                            @Override
                            public void messagesAdded(MessageCountEvent event) {
                                List<Message> messages = Arrays.asList(event.getMessages());
                                MailNotificationService.this.messageHandlers.forEach(handler -> handler.accept(messages));
                            }
                        });
                        LOGGER.debug("start notification service: {}", (Object)this.notificationWorker);
                        this.notificationWorker.accept(folder.getFolder());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (folder == null) continue;
                        if (throwable != null) {
                            try {
                                folder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        folder.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error while waiting for notifications", (Throwable)e);
                }
            }
        });
    }

    private NotificationWorker getNotificationWorker() {
        if (this.supportsIdle()) {
            return new IdleNotificationWorker();
        }
        return new PollNotificationWorker(this.configuration.getNotificationLookupTime());
    }

    public void stop() {
        LOGGER.debug("stop notification service");
        this.running.set(false);
        this.notificationWorker.stop();
        try {
            this.completion.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean supportsIdle() {
        try (FolderWrapper folder = this.mailService.getFolder(this.configuration.getPollFolder());){
            Store store = folder.getFolder().getStore();
            if (store instanceof IMAPStore) {
                IMAPStore imapStore = (IMAPStore)store;
                try {
                    boolean bl = imapStore.hasCapability("IDLE") && folder.getFolder() instanceof IMAPFolder;
                    return bl;
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerMessageHandler(MessageHandler handler) {
        this.messageHandlers.add(handler);
    }

    public MessageHandler registerMailHandler(Consumer<Mail> consumer) {
        MessageTransformationHandler handler = new MessageTransformationHandler(consumer, this.configuration.isDownloadAttachments(), this.configuration.getAttachmentPath());
        this.registerMessageHandler(handler);
        return handler;
    }

    public void unregisterMessageHandler(MessageHandler messageHandler) {
        this.messageHandlers.remove(messageHandler);
    }
}

