/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.service;

import java.util.Properties;
import java.util.function.Function;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.camunda.bpm.extension.mail.AbstractFactory;
import org.camunda.bpm.extension.mail.config.JakartaMailProperties;
import org.camunda.bpm.extension.mail.service.JakartaMailService;
import org.camunda.bpm.extension.mail.service.MailService;

public class MailServiceFactory
extends AbstractFactory<MailService> {
    private static final MailServiceFactory INSTANCE = new MailServiceFactory();

    private MailServiceFactory() {
    }

    public static MailServiceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected MailService createInstance() {
        return new JakartaMailService(this.getSession());
    }

    private Session getSession() {
        final Properties jakartaMailProperties = JakartaMailProperties.get();
        return Session.getInstance(jakartaMailProperties, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(jakartaMailProperties.getProperty("mail.user"), jakartaMailProperties.getProperty("mail.password"));
            }
        });
    }

    public void setWith(Function<Session, MailService> setter) {
        MailService mailService = setter.apply(this.getSession());
        this.set(mailService);
    }
}

