/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaMailProperties {
    private static final String ENV_PROPERTIES_PATH = "MAIL_CONFIG";
    private static final String PROPERTIES_CLASSPATH_PREFIX = "classpath:";
    private static final String DEFAULT_PROPERTIES_PATH = "classpath:mail-config.properties";
    private static final Logger LOG = LoggerFactory.getLogger(JakartaMailProperties.class);
    private static Properties properties;

    private JakartaMailProperties() {
    }

    public static void set(Properties properties) {
        JakartaMailProperties.properties = properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties get() {
        if (properties != null) {
            return properties;
        }
        Properties properties2 = new Properties();
        String path = JakartaMailProperties.getPropertiesPath();
        try (InputStream inputStream = JakartaMailProperties.getPropertiesAsStream(path);){
            if (inputStream == null) throw new IllegalStateException("Cannot find mail configuration at: " + path);
            properties2.load(inputStream);
            Properties properties = JakartaMailProperties.properties = properties2;
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load mail configuration from: " + path, e);
        }
    }

    private static String getPropertiesPath() {
        return Optional.ofNullable(System.getenv(ENV_PROPERTIES_PATH)).orElse(DEFAULT_PROPERTIES_PATH);
    }

    protected static InputStream getPropertiesAsStream(String path) throws IOException {
        if (path.startsWith(PROPERTIES_CLASSPATH_PREFIX)) {
            String pathWithoutPrefix = path.substring(PROPERTIES_CLASSPATH_PREFIX.length());
            if (pathWithoutPrefix.startsWith("/")) {
                pathWithoutPrefix = pathWithoutPrefix.substring(1);
            }
            LOG.debug("load mail properties from classpath '{}'", (Object)pathWithoutPrefix);
            return JakartaMailProperties.class.getClassLoader().getResourceAsStream(pathWithoutPrefix);
        }
        Path config = Paths.get(path, new String[0]);
        LOG.debug("load mail properties from path '{}'", (Object)config.toAbsolutePath());
        File file = config.toFile();
        if (file.exists()) {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        return null;
    }
}

