/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.poll;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.camunda.bpm.extension.mail.MailConnectorException;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.config.MailConfigurationFactory;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.poll.PollMailInvocation;
import org.camunda.bpm.extension.mail.poll.PollMailRequest;
import org.camunda.bpm.extension.mail.poll.PollMailResponse;
import org.camunda.bpm.extension.mail.service.FolderWrapper;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.bpm.extension.mail.service.MailServiceFactory;
import org.camunda.connect.impl.AbstractConnector;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollMailConnector
extends AbstractConnector<PollMailRequest, PollMailResponse> {
    public static final String CONNECTOR_ID = "mail-poll";
    private static final Logger LOGGER = LoggerFactory.getLogger(PollMailConnector.class);

    public PollMailConnector() {
        super(CONNECTOR_ID);
    }

    public PollMailRequest createRequest() {
        return new PollMailRequest((Connector<?>)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectorResponse execute(PollMailRequest request) {
        MailService mailService = (MailService)MailServiceFactory.getInstance().get();
        try {
            FolderWrapper folder = mailService.getFolder(request.getFolder());
            try {
                PollMailInvocation invocation = new PollMailInvocation(folder.getFolder(), request, this.requestInterceptors, (MailService)MailServiceFactory.getInstance().get());
                List<Mail> messages = ((List)invocation.proceed()).stream().map(message -> {
                    try {
                        return Mail.from(message);
                    }
                    catch (IOException | MessagingException e) {
                        throw new RuntimeException("Exception while transforming message to dto: " + e.getMessage(), e);
                    }
                }).peek(message -> {
                    if (request.downloadAttachments()) {
                        try {
                            message.downloadAttachments(((MailConfiguration)MailConfigurationFactory.getInstance().get()).getAttachmentPath());
                        }
                        catch (Exception e) {
                            LOGGER.error("exception while downloading attachments", (Throwable)e);
                        }
                    }
                }).collect(Collectors.toList());
                LOGGER.debug("poll {} mails from folder '{}'", (Object)messages.size(), (Object)folder.getFolder().getName());
                PollMailResponse pollMailResponse = new PollMailResponse(messages);
                return pollMailResponse;
            }
            catch (Exception e) {
                throw new MailConnectorException("Failed to poll mails: " + e.getMessage(), e);
            }
            finally {
                if (folder != null) {
                    try {
                        folder.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (MessagingException e) {
            throw new MailConnectorException("Failed to poll mails: " + e.getMessage(), e);
        }
    }
}

