/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.send;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.extension.mail.EmptyResponse;
import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.config.MailConfigurationFactory;
import org.camunda.connect.impl.AbstractConnectorRequest;
import org.camunda.connect.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailRequest
extends AbstractConnectorRequest<EmptyResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMailRequest.class);
    protected static final String PARAM_FROM = "from";
    protected static final String PARAM_FROM_ALIAS = "fromAlias";
    protected static final String PARAM_TO = "to";
    protected static final String PARAM_CC = "cc";
    protected static final String PARAM_BCC = "bcc";
    protected static final String PARAM_SUBJECT = "subject";
    protected static final String PARAM_TEXT = "text";
    protected static final String PARAM_HTML = "html";
    protected static final String PARAM_FILE_NAMES = "fileNames";
    protected static final String PARAM_FILES = "files";
    protected final MailConfiguration configuration = (MailConfiguration)MailConfigurationFactory.getInstance().get();

    public SendMailRequest(Connector<?> connector) {
        super(connector);
    }

    public String getTo() {
        return (String)this.getRequestParameter(PARAM_TO);
    }

    public SendMailRequest to(String to) {
        this.setRequestParameter(PARAM_TO, to);
        return this;
    }

    public String getFrom() {
        String from = (String)this.getRequestParameter(PARAM_FROM);
        if (from == null) {
            from = this.configuration.getSender();
        }
        return from;
    }

    public SendMailRequest from(String from) {
        this.setRequestParameter(PARAM_FROM, from);
        return this;
    }

    public String getFromAlias() {
        String alias = (String)this.getRequestParameter(PARAM_FROM_ALIAS);
        if (alias == null) {
            alias = this.configuration.getSenderAlias();
        }
        return alias;
    }

    public SendMailRequest fromAlias(String alias) {
        this.setRequestParameter(PARAM_FROM_ALIAS, alias);
        return this;
    }

    public String getCc() {
        return (String)this.getRequestParameter(PARAM_CC);
    }

    public SendMailRequest cc(String cc) {
        this.setRequestParameter(PARAM_CC, cc);
        return this;
    }

    public String getBcc() {
        return (String)this.getRequestParameter(PARAM_BCC);
    }

    public SendMailRequest bcc(String bcc) {
        this.setRequestParameter(PARAM_BCC, bcc);
        return this;
    }

    public String getSubject() {
        return (String)this.getRequestParameter(PARAM_SUBJECT);
    }

    public SendMailRequest subject(String subject) {
        this.setRequestParameter(PARAM_SUBJECT, subject);
        return this;
    }

    public String getText() {
        return (String)this.getRequestParameter(PARAM_TEXT);
    }

    public SendMailRequest text(String text) {
        this.setRequestParameter(PARAM_TEXT, text);
        return this;
    }

    public String getHtml() {
        return (String)this.getRequestParameter(PARAM_HTML);
    }

    public SendMailRequest html(String html) {
        this.setRequestParameter(PARAM_HTML, html);
        return this;
    }

    public List<String> getFileNames() {
        return (List)this.getRequestParameter(PARAM_FILE_NAMES);
    }

    public SendMailRequest fileNames(String ... fileNames) {
        this.setRequestParameter(PARAM_FILE_NAMES, Arrays.asList(fileNames));
        return this;
    }

    public Map<String, ByteArrayInputStream> getFiles() {
        return (Map)this.getRequestParameter(PARAM_FILES);
    }

    public SendMailRequest files(Map<String, ByteArrayInputStream> files) {
        this.setRequestParameter(PARAM_FILES, files);
        return this;
    }

    protected boolean isRequestValid() {
        if (this.getTo() == null || this.getTo().isEmpty()) {
            LOGGER.warn("invalid request: missing parameter 'to' in {}", (Object)this);
            return false;
        }
        if (this.getFrom() == null || this.getFrom().isEmpty()) {
            LOGGER.warn("invalid request: missing parameter 'from' in {}", (Object)this);
            return false;
        }
        return true;
    }

    public String toString() {
        return "SendMailRequest [from=" + this.getFrom() + ", from-alias=" + this.getFromAlias() + ", to=" + this.getTo() + ", cc=" + this.getCc() + ", bcc=" + this.getBcc() + ", subject=" + this.getSubject() + ", text=" + this.getText() + ", html=" + this.getHtml() + "]";
    }
}

