/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.mail.Message;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.notification.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTransformationHandler
implements MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageTransformationHandler.class);
    protected final Consumer<Mail> consumer;
    protected final boolean downloadAttachments;
    protected final String attachmentPath;

    public MessageTransformationHandler(Consumer<Mail> consumer) {
        this(consumer, false, null);
    }

    public MessageTransformationHandler(Consumer<Mail> consumer, boolean downloadAttachments, String attachmentPath) {
        this.consumer = consumer;
        this.downloadAttachments = downloadAttachments;
        this.attachmentPath = attachmentPath;
    }

    @Override
    public void accept(List<Message> messages) {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        for (Message message : messages) {
            try {
                Mail mail = Mail.from(message);
                if (this.downloadAttachments) {
                    mail.downloadAttachments(this.attachmentPath);
                }
                mails.add(mail);
            }
            catch (Exception e) {
                LOGGER.warn("exception while transforming a message", (Throwable)e);
            }
        }
        LOGGER.debug("received {} new mails: {}", (Object)mails.size(), mails);
        mails.forEach(this.consumer);
    }
}

