/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.service;

import java.util.Properties;
import java.util.function.Function;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.camunda.bpm.extension.mail.AbstractFactory;
import org.camunda.bpm.extension.mail.config.JakartaMailProperties;
import org.camunda.bpm.extension.mail.service.JakartaMailService;
import org.camunda.bpm.extension.mail.service.MailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServiceFactory
extends AbstractFactory<MailService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServiceFactory.class);
    private static final MailServiceFactory INSTANCE = new MailServiceFactory();

    private MailServiceFactory() {
    }

    public static MailServiceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected MailService createInstance() {
        return new JakartaMailService(this.getSession());
    }

    private Session getSession() {
        Session session;
        final Properties jakartaMailProperties = JakartaMailProperties.get();
        if (this.isJndiSession(jakartaMailProperties)) {
            String jndiName = this.extractJndiName(jakartaMailProperties);
            try {
                LOGGER.debug("Lookup mail session with jndi-name: {}", (Object)jndiName);
                InitialContext ictx = new InitialContext();
                session = (Session)ictx.lookup(jndiName);
            }
            catch (NamingException e) {
                String msg = String.format("Cannot connect to mail session under jndi-name '%s' :", jndiName);
                LOGGER.error(msg, (Throwable)e);
                throw new IllegalArgumentException(msg, e);
            }
        } else {
            session = Session.getInstance(jakartaMailProperties, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(jakartaMailProperties.getProperty("mail.user"), jakartaMailProperties.getProperty("mail.password"));
                }
            });
        }
        return session;
    }

    private boolean isJndiSession(Properties properties) {
        String jndiName = this.extractJndiName(properties);
        return jndiName != null && !jndiName.trim().isEmpty();
    }

    private String extractJndiName(Properties properties) {
        return properties.getProperty("mail.session.jndi.name");
    }

    public void setWith(Function<Session, MailService> setter) {
        MailService mailService = setter.apply(this.getSession());
        this.set(mailService);
    }
}

