/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaMailProperties {
    public static final String PROP_NAME_MAIL_SESSION_JNDI_NAME = "mail.session.jndi.name";
    private static final String ENV_PROPERTIES_PATH = "MAIL_CONFIG";
    private static final String PROPERTIES_CLASSPATH_PREFIX = "classpath:";
    static final String PROPERTIES_JNDI_PREFIX = "jndi:";
    private static final String DEFAULT_PROPERTIES_PATH = "classpath:mail-config.properties";
    private static final Logger LOG = LoggerFactory.getLogger(JakartaMailProperties.class);
    private static String propertiesPath;
    private static Properties properties;

    private JakartaMailProperties() {
    }

    public static void set(Properties properties) {
        JakartaMailProperties.properties = properties;
    }

    public static void setPropertiesPath(String path) {
        propertiesPath = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties get() {
        if (properties != null) {
            return properties;
        }
        Properties properties2 = new Properties();
        String path = JakartaMailProperties.getPropertiesPath();
        if (JakartaMailProperties.isJndiPath(path)) {
            properties2.setProperty(PROP_NAME_MAIL_SESSION_JNDI_NAME, JakartaMailProperties.extractJndiName(path));
            return properties2;
        }
        try (InputStream inputStream = JakartaMailProperties.getPropertiesAsStream(path);){
            if (inputStream == null) throw new IllegalStateException("Cannot find mail configuration at: " + path);
            properties2.load(inputStream);
            Properties properties = JakartaMailProperties.properties = properties2;
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load mail configuration from: " + path, e);
        }
    }

    private static String getPropertiesPath() {
        return Optional.ofNullable(propertiesPath).orElse(Optional.ofNullable(System.getenv(ENV_PROPERTIES_PATH)).orElse(DEFAULT_PROPERTIES_PATH));
    }

    private static boolean isJndiPath(String path) {
        return path.startsWith(PROPERTIES_JNDI_PREFIX);
    }

    private static boolean isClasspathPath(String path) {
        return path.startsWith(PROPERTIES_CLASSPATH_PREFIX);
    }

    private static String extractJndiName(String path) {
        return path.substring(PROPERTIES_JNDI_PREFIX.length());
    }

    private static String extractClasspath(String path) {
        String classpath = path.substring(PROPERTIES_CLASSPATH_PREFIX.length());
        if (classpath.startsWith("/")) {
            classpath = classpath.substring(1);
        }
        return classpath;
    }

    protected static InputStream getPropertiesAsStream(String path) throws IOException {
        if (JakartaMailProperties.isClasspathPath(path)) {
            String classpath = JakartaMailProperties.extractClasspath(path);
            LOG.debug("load mail properties from classpath '{}'", (Object)classpath);
            return JakartaMailProperties.class.getClassLoader().getResourceAsStream(classpath);
        }
        Path config = Paths.get(path, new String[0]);
        LOG.debug("load mail properties from path '{}'", (Object)config.toAbsolutePath());
        if (config.toFile().exists()) {
            return Files.newInputStream(config, new OpenOption[0]);
        }
        return null;
    }
}

