/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.delete;

import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.search.MessageIDTerm;
import jakarta.mail.search.OrTerm;
import jakarta.mail.search.SearchTerm;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.camunda.bpm.extension.mail.EmptyResponse;
import org.camunda.bpm.extension.mail.MailConnectorException;
import org.camunda.bpm.extension.mail.delete.DeleteMailInvocation;
import org.camunda.bpm.extension.mail.delete.DeleteMailRequest;
import org.camunda.bpm.extension.mail.dto.Mail;
import org.camunda.bpm.extension.mail.service.FolderWrapper;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.bpm.extension.mail.service.MailServiceFactory;
import org.camunda.connect.impl.AbstractConnector;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteMailConnector
extends AbstractConnector<DeleteMailRequest, EmptyResponse> {
    public static final String CONNECTOR_ID = "mail-delete";
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteMailConnector.class);

    public DeleteMailConnector() {
        super(CONNECTOR_ID);
    }

    public DeleteMailRequest createRequest() {
        return new DeleteMailRequest((Connector<?>)this);
    }

    public ConnectorResponse execute(DeleteMailRequest request) {
        EmptyResponse emptyResponse;
        block8: {
            MailService mailService = (MailService)MailServiceFactory.getInstance().get();
            FolderWrapper folder = mailService.getFolder(request.getFolder());
            try {
                List<Message> messages = this.getMessages(folder.getFolder(), request);
                DeleteMailInvocation invocation = new DeleteMailInvocation(messages, request, this.requestInterceptors, mailService);
                invocation.proceed();
                emptyResponse = new EmptyResponse();
                if (folder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (folder != null) {
                        try {
                            folder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MailConnectorException("Failed to delete mails: " + e.getMessage(), e);
                }
            }
            folder.close();
        }
        return emptyResponse;
    }

    protected List<Message> getMessages(Folder folder, DeleteMailRequest request) {
        if (request.getMails() != null) {
            LOGGER.debug("delete mails: {}", request.getMails());
            List<String> messageIds = this.collectMessageIds(request.getMails());
            return Arrays.asList(this.getMessagesByIds(folder, messageIds));
        }
        if (request.getMessageIds() != null) {
            LOGGER.debug("delete mails with message ids: {}", request.getMessageIds());
            return Arrays.asList(this.getMessagesByIds(folder, request.getMessageIds()));
        }
        LOGGER.debug("delete mails with message numbers: {}", request.getMessageNumbers());
        int[] numbers = request.getMessageNumbers().stream().mapToInt(i -> i).toArray();
        try {
            return Arrays.asList(folder.getMessages(numbers));
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> collectMessageIds(List<Mail> mails) {
        return mails.stream().map(m -> Optional.ofNullable(m.getMessageId()).orElse("")).filter(id -> !id.isEmpty()).collect(Collectors.toList());
    }

    protected Message[] getMessagesByIds(Folder folder, List<String> messageIds) {
        OrTerm searchTerm = new OrTerm((SearchTerm[])messageIds.stream().map(MessageIDTerm::new).toArray(MessageIDTerm[]::new));
        try {
            return folder.search(searchTerm);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

