/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.send;

import jakarta.activation.DataHandler;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Date;
import java.util.Map;
import org.camunda.bpm.extension.mail.EmptyResponse;
import org.camunda.bpm.extension.mail.MailConnectorException;
import org.camunda.bpm.extension.mail.MailContentType;
import org.camunda.bpm.extension.mail.send.SendMailInvocation;
import org.camunda.bpm.extension.mail.send.SendMailRequest;
import org.camunda.bpm.extension.mail.service.MailService;
import org.camunda.bpm.extension.mail.service.MailServiceFactory;
import org.camunda.connect.impl.AbstractConnector;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorResponse;

public class SendMailConnector
extends AbstractConnector<SendMailRequest, EmptyResponse> {
    public static final String CONNECTOR_ID = "mail-send";

    public SendMailConnector() {
        super(CONNECTOR_ID);
    }

    public SendMailRequest createRequest() {
        return new SendMailRequest((Connector<?>)this);
    }

    public ConnectorResponse execute(SendMailRequest request) {
        try {
            Message message = this.createMessage(request);
            SendMailInvocation invocation = new SendMailInvocation(message, request, this.requestInterceptors);
            invocation.proceed();
        }
        catch (Exception e) {
            throw new MailConnectorException("Failed to send mail: " + e.getMessage(), e);
        }
        return new EmptyResponse();
    }

    protected Message createMessage(SendMailRequest request) throws Exception {
        Message message = ((MailService)MailServiceFactory.getInstance().get()).createMessage();
        message.setFrom(new InternetAddress(request.getFrom(), request.getFromAlias()));
        message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(request.getTo()));
        if (request.getCc() != null) {
            message.setRecipients(Message.RecipientType.CC, InternetAddress.parse(request.getCc()));
        }
        if (request.getBcc() != null) {
            message.setRecipients(Message.RecipientType.BCC, InternetAddress.parse(request.getBcc()));
        }
        message.setSentDate(new Date());
        message.setSubject(request.getSubject());
        if (this.hasContent(request)) {
            this.createMessageContent(message, request);
        } else {
            message.setText("");
        }
        return message;
    }

    protected boolean hasContent(SendMailRequest request) {
        return request.getText() != null || request.getHtml() != null || request.getFileNames() != null && !request.getFileNames().isEmpty();
    }

    protected void createMessageContent(Message message, SendMailRequest request) throws MessagingException, IOException {
        if (this.isTextOnlyMessage(request)) {
            message.setText(request.getText());
        } else {
            MimeMultipart multiPart = new MimeMultipart();
            if (request.getText() != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(request.getText());
                ((Multipart)multiPart).addBodyPart(textPart);
            }
            if (request.getHtml() != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent(request.getHtml(), MailContentType.TEXT_HTML.getType());
                ((Multipart)multiPart).addBodyPart(htmlPart);
            }
            if (request.getFileNames() != null) {
                for (String string : request.getFileNames()) {
                    MimeBodyPart part = new MimeBodyPart();
                    part.attachFile(string);
                    ((Multipart)multiPart).addBodyPart(part);
                }
            }
            if (request.getFiles() != null) {
                for (Map.Entry entry : request.getFiles().entrySet()) {
                    ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)entry.getValue(), URLConnection.guessContentTypeFromName((String)entry.getKey()));
                    MimeBodyPart part = new MimeBodyPart();
                    part.setFileName((String)entry.getKey());
                    part.setDataHandler(new DataHandler(ds));
                    ((Multipart)multiPart).addBodyPart(part);
                }
            }
            message.setContent(multiPart);
        }
    }

    protected boolean isTextOnlyMessage(SendMailRequest request) {
        return request.getHtml() == null && request.getFileNames() == null && request.getFiles() == null;
    }
}

