/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.poll;

import org.camunda.bpm.extension.mail.config.MailConfiguration;
import org.camunda.bpm.extension.mail.config.MailConfigurationFactory;
import org.camunda.bpm.extension.mail.poll.PollMailResponse;
import org.camunda.connect.impl.AbstractConnectorRequest;
import org.camunda.connect.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollMailRequest
extends AbstractConnectorRequest<PollMailResponse> {
    protected static final String PARAM_FOLDER = "folder";
    protected static final String[] PARAM_DOWNLOAD_ATTACHMENTS = new String[]{"download-attachments", "download-attachements"};
    private static final Logger LOGGER = LoggerFactory.getLogger(PollMailRequest.class);

    public PollMailRequest(Connector<?> connector) {
        super(connector);
    }

    public String getFolder() {
        String folder = (String)this.getRequestParameter(PARAM_FOLDER);
        if (folder == null) {
            folder = ((MailConfiguration)MailConfigurationFactory.getInstance().get()).getPollFolder();
        }
        return folder;
    }

    public PollMailRequest folder(String folder) {
        this.setRequestParameter(PARAM_FOLDER, folder);
        return this;
    }

    public boolean downloadAttachments() {
        Boolean downloadAttachments = (Boolean)this.getRequestParameter(PARAM_DOWNLOAD_ATTACHMENTS[0]);
        if (downloadAttachments == null) {
            downloadAttachments = (Boolean)this.getRequestParameter(PARAM_DOWNLOAD_ATTACHMENTS[1]);
        }
        if (downloadAttachments == null) {
            downloadAttachments = ((MailConfiguration)MailConfigurationFactory.getInstance().get()).isDownloadAttachments();
        }
        return downloadAttachments;
    }

    public PollMailRequest downloadAttachments(boolean downloadAttachments) {
        this.setRequestParameter(PARAM_DOWNLOAD_ATTACHMENTS[0], downloadAttachments);
        return this;
    }

    protected boolean isRequestValid() {
        if (this.getFolder() == null || this.getFolder().isEmpty()) {
            LOGGER.warn("invalid request: missing parameter 'folder' in {}", (Object)this);
            return false;
        }
        return true;
    }

    public String toString() {
        return "PollMailRequest [folder=" + this.getFolder() + ", download-attachments=" + this.downloadAttachments() + "]";
    }
}

