/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.dto;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.camunda.bpm.extension.mail.dto.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mail
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mail.class);
    private static final long serialVersionUID = 1L;
    private String from;
    private String to;
    private String cc;
    private String subject;
    private Date sentDate;
    private Date receivedDate;
    private int messageNumber;
    private String messageId;
    private String text;
    private String html;
    private final List<Attachment> attachments = new ArrayList<Attachment>();

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public static Mail from(Message message) throws MessagingException, IOException {
        Mail mail = new Mail();
        mail.from = InternetAddress.toString(message.getFrom());
        mail.to = InternetAddress.toString(message.getRecipients(Message.RecipientType.TO));
        mail.cc = InternetAddress.toString(message.getRecipients(Message.RecipientType.CC));
        mail.subject = message.getSubject();
        mail.sentDate = message.getSentDate();
        mail.receivedDate = message.getReceivedDate();
        mail.messageNumber = message.getMessageNumber();
        if (message instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)message;
            mail.messageId = mimeMessage.getMessageID();
        }
        Mail.processMessageContent(message, mail);
        return mail;
    }

    protected static void processMessageContent(Message message, Mail mail) throws MessagingException, IOException {
        if (Mail.isMultipartMessage(message)) {
            Multipart multipart = (Multipart)message.getContent();
            int numberOfParts = multipart.getCount();
            for (int partCount = 0; partCount < numberOfParts; ++partCount) {
                BodyPart bodyPart = multipart.getBodyPart(partCount);
                Mail.processMessagePartContent(bodyPart, mail);
            }
        } else {
            Mail.processMessagePartContent(message, mail);
        }
    }

    protected static boolean isMultipartMessage(Message message) throws MessagingException, IOException {
        return message.isMimeType("multipart") || message.getContent() instanceof Multipart;
    }

    protected static void processMessagePartContent(Part part, Mail mail) throws MessagingException, IOException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            Attachment attachment = Attachment.from(part);
            mail.attachments.add(attachment);
        } else if (part.isMimeType("text/plain")) {
            mail.text = (String)part.getContent();
        } else if (part.isMimeType("text/html")) {
            mail.html = (String)part.getContent();
        }
    }

    public void downloadAttachments(String attachmentPath) throws IOException, MessagingException {
        if (!this.attachments.isEmpty()) {
            LOGGER.debug("download attachments of mail: {}", (Object)this);
            String uuid = UUID.randomUUID().toString();
            Path downloadPath = Paths.get(attachmentPath, uuid);
            Files.createDirectories(downloadPath, new FileAttribute[0]);
            for (Attachment attachment : this.attachments) {
                attachment.download(downloadPath);
                LOGGER.debug("downloaded '{}'", (Object)attachment);
            }
        }
    }

    public String toString() {
        return "Mail [from=" + this.from + ", to=" + this.to + ", cc=" + this.cc + ", subject=" + this.subject + ", sentDate=" + this.sentDate + ", receivedDate=" + this.receivedDate + ", messageNumber=" + this.messageNumber + ", messageId=" + this.messageId + ", attachments=" + this.attachments + " ]";
    }
}

