/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import jakarta.mail.MessagingException;
import org.camunda.bpm.extension.mail.notification.AbstractNotificationWorker;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleNotificationWorker
extends AbstractNotificationWorker<IMAPFolder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleNotificationWorker.class);

    @Override
    protected void interrupt() {
        try {
            ((IMAPFolder)this.folder).doCommand(p -> {
                p.simpleCommand("NOOP", null);
                return null;
            });
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    @Override
    protected void idle() {
        try {
            LOGGER.debug("waiting for mails");
            ((IMAPFolder)this.folder).idle();
        }
        catch (Exception e) {
            LOGGER.debug("exception while waiting for mails", (Throwable)e);
        }
    }
}

