/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.service;

import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.camunda.bpm.extension.mail.service.FolderWrapper;
import org.camunda.bpm.extension.mail.service.MailService;

public class JakartaMailService
implements MailService {
    private final Session session;
    private final Queue<Store> availableStores = new ArrayBlockingQueue<Store>(100);
    private boolean usesLifecycle = false;

    public JakartaMailService(Session session) {
        this.session = session;
    }

    @Override
    public Message createMessage() {
        return new MimeMessage(this.session);
    }

    @Override
    public void sendMessage(Message message) throws MessagingException {
        try (Transport transport = this.session.getTransport();){
            transport.connect();
            transport.sendMessage(message, message.getAllRecipients());
        }
    }

    private Store provideStore() throws MessagingException {
        Store store = this.availableStores.poll();
        if (store == null) {
            store = this.session.getStore();
        }
        if (!store.isConnected()) {
            store.connect();
        }
        return store;
    }

    private void returnStore(Store store) {
        if (this.usesLifecycle && this.availableStores.offer(store)) {
            return;
        }
        try {
            store.close();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FolderWrapper getFolder(String folderName) throws MessagingException {
        Store store = this.provideStore();
        Folder folder = store.getFolder(folderName);
        folder.open(2);
        return new FolderWrapper(folder, () -> this.returnStore(store));
    }

    public void start() {
        this.usesLifecycle = true;
    }

    public void stop() {
        this.usesLifecycle = false;
        Store store = this.availableStores.poll();
        while (store != null) {
            try {
                store.close();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            store = this.availableStores.poll();
        }
    }

    public boolean isRunning() {
        return this.usesLifecycle;
    }
}

