/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import jakarta.mail.Folder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.camunda.bpm.extension.mail.notification.NotificationWorker;

public abstract class AbstractNotificationWorker<T extends Folder>
implements NotificationWorker {
    private final AtomicBoolean running = new AtomicBoolean(false);
    protected T folder;

    @Override
    public final void stop() {
        this.running.set(false);
        this.interrupt();
    }

    protected abstract void interrupt();

    @Override
    public final void accept(Folder folder) {
        this.folder = folder;
        this.running.set(true);
        while (this.running.get()) {
            this.idle();
        }
    }

    protected abstract void idle();

    protected boolean isRunning() {
        return this.running.get();
    }
}

