/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.dto;

import jakarta.activation.DataHandler;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private String path;
    private transient Part part;

    public static Attachment from(Part part) throws MessagingException {
        Attachment attachment = new Attachment();
        attachment.fileName = part.getFileName();
        attachment.part = part;
        return attachment;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public Path download(Path downloadPath) throws MessagingException, IOException {
        Path newFile = downloadPath.resolve(this.fileName);
        int prefixCounter = 0;
        while (Files.exists(newFile, new LinkOption[0])) {
            newFile = downloadPath.resolve(prefixCounter + "-" + this.fileName);
            ++prefixCounter;
        }
        DataHandler dataHandler = this.part.getDataHandler();
        Files.copy(dataHandler.getInputStream(), newFile, new CopyOption[0]);
        this.path = newFile.toAbsolutePath().toString();
        return newFile;
    }

    public String toString() {
        return "Attachment [fileName=" + this.fileName + ", path=" + this.path + "]";
    }
}

