/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mail.notification;

import jakarta.mail.Folder;
import java.time.Duration;
import org.camunda.bpm.extension.mail.notification.AbstractNotificationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollNotificationWorker
extends AbstractNotificationWorker<Folder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollNotificationWorker.class);
    protected final Duration lookupTime;

    public PollNotificationWorker(Duration lookupTime) {
        this.lookupTime = lookupTime;
    }

    protected void triggerMailServer() {
        try {
            LOGGER.debug("trigger the mail server");
            this.folder.getMessageCount();
        }
        catch (Exception e) {
            LOGGER.debug("exception while triggering mail server", (Throwable)e);
        }
    }

    protected void waitTillNextLookup() {
        try {
            Thread.sleep(this.lookupTime.toMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void interrupt() {
        PollNotificationWorker pollNotificationWorker = this;
        synchronized (pollNotificationWorker) {
            this.notifyAll();
        }
    }

    @Override
    protected void idle() {
        this.triggerMailServer();
        this.waitTillNextLookup();
    }

    public String toString() {
        return "PollNotificationWorker [folder=" + this.folder.getName() + ", lookupTime=" + String.valueOf(this.lookupTime) + ", running=" + this.isRunning() + "]";
    }
}

