/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import org.apache.commons.lang.StringUtils;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="camunda.bpm")
public class CamundaBpmProperties {
    protected static final HistoryLevel[] HISTORY_LEVELS = new HistoryLevel[]{HistoryLevel.HISTORY_LEVEL_ACTIVITY, HistoryLevel.HISTORY_LEVEL_AUDIT, HistoryLevel.HISTORY_LEVEL_FULL, HistoryLevel.HISTORY_LEVEL_NONE};
    private String processEngineName;
    private HistoryLevel historyLevel;
    private boolean autoDeploymentEnabled = true;
    private String[] deploymentResourcePattern = new String[]{"classpath*:**/*.bpmn", "classpath*:**/*.bpmn20.xml", "classpath*:**/*.cmmn", "classpath*:**/*.cmmn10.xml"};
    private Database database = new Database();
    private Jpa jpa = new Jpa();
    private JobExecution jobExecution = new JobExecution();
    private Rest rest = new Rest();

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Jpa getJpa() {
        return this.jpa;
    }

    public void setJpa(Jpa jpa) {
        this.jpa = jpa;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public void setJobExecution(JobExecution jobExecution) {
        this.jobExecution = jobExecution;
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    public void setHistoryLevel(String historyLevelString) {
        if (StringUtils.isNotBlank((String)historyLevelString)) {
            for (HistoryLevel historyLevel : HISTORY_LEVELS) {
                if (!historyLevel.getName().toUpperCase().equals(historyLevelString.toUpperCase())) continue;
                this.historyLevel = historyLevel;
                break;
            }
        }
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public boolean isAutoDeploymentEnabled() {
        return this.autoDeploymentEnabled;
    }

    public void setAutoDeploymentEnabled(boolean autoDeploymentEnabled) {
        this.autoDeploymentEnabled = autoDeploymentEnabled;
    }

    public String[] getDeploymentResourcePattern() {
        return this.deploymentResourcePattern;
    }

    public void setDeploymentResourcePattern(String[] deploymentResourcePattern) {
        this.deploymentResourcePattern = deploymentResourcePattern;
    }

    public Rest getRest() {
        return this.rest;
    }

    public void setRest(Rest rest) {
        this.rest = rest;
    }

    public static class Jpa {
        private boolean enabled;
        private String persistenceUnitName;
        private boolean closeEntityManager = true;
        private boolean handleTransaction = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public void setPersistenceUnitName(String persistenceUnitName) {
            this.persistenceUnitName = persistenceUnitName;
        }

        public boolean isCloseEntityManager() {
            return this.closeEntityManager;
        }

        public void setCloseEntityManager(boolean closeEntityManager) {
            this.closeEntityManager = closeEntityManager;
        }

        public boolean isHandleTransaction() {
            return this.handleTransaction;
        }

        public void setHandleTransaction(boolean handleTransaction) {
            this.handleTransaction = handleTransaction;
        }
    }

    public static class Rest {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class JobExecution {
        private boolean enabled;
        private boolean active = true;
        private boolean deploymentAware;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isDeploymentAware() {
            return this.deploymentAware;
        }

        public void setDeploymentAware(boolean deploymentAware) {
            this.deploymentAware = deploymentAware;
        }
    }

    public class Database {
        private boolean schemaUpdate = true;
        private String type;
        private String tablePrefix;

        public boolean isSchemaUpdate() {
            return this.schemaUpdate;
        }

        public void setSchemaUpdate(boolean schemaUpdate) {
            this.schemaUpdate = schemaUpdate;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTablePrefix() {
            return this.tablePrefix;
        }

        public void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }
    }
}

