/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.ws.rs.core.Application;
import org.camunda.bpm.engine.rest.impl.CamundaRestResources;
import org.glassfish.jersey.server.ResourceConfig;
import org.jboss.resteasy.plugins.server.servlet.FilterDispatcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={ResourceConfig.class, FilterDispatcher.class})
@ConditionalOnProperty(prefix="camunda.bpm.rest", name={"enabled"}, matchIfMissing=true)
public class CamundaBpmRestConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"filterDispatcherRegistrationBean"})
    public FilterRegistrationBean filterDispatcherRegistrationBean(@Qualifier(value="filterDispatcher") Filter filterDispatcher) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setName("Resteasy");
        filterRegistrationBean.setFilter(filterDispatcher);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("javax.ws.rs.Application", RestProcessEngineDeployment.class.getName());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(name={"filterDispatcher"})
    public static Filter filterDispatcher() {
        return new FilterDispatcher();
    }

    public static class RestProcessEngineDeployment
    extends Application {
        public Set<Class<?>> getClasses() {
            HashSet classes = new HashSet();
            classes.addAll(CamundaRestResources.getResourceClasses());
            classes.addAll(CamundaRestResources.getConfigurationClasses());
            return classes;
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    public static class JerseyConfig
    extends ResourceConfig {
        public JerseyConfig() {
            this.registerClasses(CamundaRestResources.getResourceClasses());
            this.registerClasses(CamundaRestResources.getConfigurationClasses());
        }
    }
}

