/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import javax.sql.DataSource;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaDatasourceConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

public class DefaultDatasourceConfiguration
extends AbstractCamundaConfiguration
implements CamundaDatasourceConfiguration {
    @Autowired
    protected PlatformTransactionManager transactionManager;
    @Autowired
    protected DataSource dataSource;
    @Autowired(required=false)
    @Qualifier(value="camundaBpmDataSource")
    protected DataSource camundaDataSource;

    @Override
    public void apply(SpringProcessEngineConfiguration configuration) {
        configuration.setTransactionManager(this.transactionManager);
        if (this.camundaDataSource == null) {
            configuration.setDataSource(this.dataSource);
        } else {
            configuration.setDataSource(this.camundaDataSource);
        }
        configuration.setDatabaseType(this.camundaBpmProperties.getDatabase().getType());
        configuration.setDatabaseSchemaUpdate(Boolean.toString(this.camundaBpmProperties.getDatabase().isSchemaUpdate()));
        if (!StringUtils.isEmpty((Object)this.camundaBpmProperties.getDatabase().getTablePrefix())) {
            configuration.setDatabaseTablePrefix(this.camundaBpmProperties.getDatabase().getTablePrefix());
        }
    }
}

