/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import java.util.Arrays;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaDeploymentConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;

public class DefaultDeploymentConfiguration
extends AbstractCamundaConfiguration
implements CamundaDeploymentConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeploymentConfiguration.class);

    @Override
    public void apply(SpringProcessEngineConfiguration configuration) {
        if (this.camundaBpmProperties.isAutoDeploymentEnabled()) {
            configuration.setDeploymentResources(this.getDeploymentResources());
        }
    }

    protected Resource[] getDeploymentResources() {
        Resource[] resources = null;
        ResourceArrayPropertyEditor resolver = new ResourceArrayPropertyEditor();
        try {
            Object[] resourcePattern = this.camundaBpmProperties.getDeploymentResourcePattern();
            LOGGER.debug("resolving deployment resources for pattern {}", resourcePattern);
            resolver.setValue((Object)resourcePattern);
            resources = (Resource[])resolver.getValue();
            LOGGER.debug("resolved {}", Arrays.asList(resources));
        }
        catch (RuntimeException e) {
            LOGGER.error("unable to resolve resources", (Throwable)e);
        }
        return resources;
    }
}

