/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.camunda.bpm.application.impl.metadata.ProcessArchiveXmlImpl;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.dmn.deployer.DmnDeployer;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.metrics.MetricsReporterIdProvider;
import org.camunda.bpm.engine.impl.metrics.reporter.DbMetricsReporter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="camunda.bpm")
public class CamundaBpmProperties {
    private String processEngineName = "default";
    private String historyLevel;
    private String historyLevelDefault;
    private boolean autoDeploymentEnabled = true;
    private String[] deploymentResourcePattern = CamundaBpmProperties.initDeploymentResourcePattern();
    private Metrics metrics = new Metrics();
    private Rest rest = new Rest();
    private Database database = new Database();
    private Jpa jpa = new Jpa();
    private JobExecution jobExecution = new JobExecution();
    private Webapp webapp = new Webapp();
    private Application application = new Application();

    static String[] initDeploymentResourcePattern() {
        HashSet<String> suffixes = new HashSet<String>();
        suffixes.addAll(Arrays.asList(DmnDeployer.DMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(BpmnDeployer.BPMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(CmmnDeployer.CMMN_RESOURCE_SUFFIXES));
        HashSet<String> patterns = new HashSet<String>();
        for (String suffix : suffixes) {
            patterns.add(String.format("%s**/*.%s", "classpath*:", suffix));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    public String getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(String historyLevel) {
        this.historyLevel = historyLevel;
    }

    public String getHistoryLevelDefault() {
        return this.historyLevelDefault;
    }

    public void setHistoryLevelDefault(String historyLevelDefault) {
        this.historyLevelDefault = historyLevelDefault;
    }

    public boolean isAutoDeploymentEnabled() {
        return this.autoDeploymentEnabled;
    }

    public void setAutoDeploymentEnabled(boolean autoDeploymentEnabled) {
        this.autoDeploymentEnabled = autoDeploymentEnabled;
    }

    public String[] getDeploymentResourcePattern() {
        return this.deploymentResourcePattern;
    }

    public void setDeploymentResourcePattern(String[] deploymentResourcePattern) {
        this.deploymentResourcePattern = deploymentResourcePattern;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public Rest getRest() {
        return this.rest;
    }

    public void setRest(Rest rest) {
        this.rest = rest;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Jpa getJpa() {
        return this.jpa;
    }

    public void setJpa(Jpa jpa) {
        this.jpa = jpa;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public void setJobExecution(JobExecution jobExecution) {
        this.jobExecution = jobExecution;
    }

    public Webapp getWebapp() {
        return this.webapp;
    }

    public void setWebapp(Webapp webapp) {
        this.webapp = webapp;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static class Application
    extends NestedProperty {
        private boolean isDeleteUponUndeploy = false;
        private boolean isScanForProcessDefinitions = true;
        private boolean isDeployChangedOnly = false;
        private boolean isResumePreviousVersions = false;
        private String resumePreviousBy = "process-definition-key";

        public boolean isDeleteUponUndeploy() {
            return this.isDeleteUponUndeploy;
        }

        public void setDeleteUponUndeploy(boolean deleteUponUndeploy) {
            this.isDeleteUponUndeploy = deleteUponUndeploy;
        }

        public boolean isScanForProcessDefinitions() {
            return this.isScanForProcessDefinitions;
        }

        public void setScanForProcessDefinitions(boolean scanForProcessDefinitions) {
            this.isScanForProcessDefinitions = scanForProcessDefinitions;
        }

        public boolean isDeployChangedOnly() {
            return this.isDeployChangedOnly;
        }

        public void setDeployChangedOnly(boolean deployChangedOnly) {
            this.isDeployChangedOnly = deployChangedOnly;
        }

        public boolean isResumePreviousVersions() {
            return this.isResumePreviousVersions;
        }

        public void setResumePreviousVersions(boolean resumePreviousVersions) {
            this.isResumePreviousVersions = resumePreviousVersions;
        }

        public String getResumePreviousBy() {
            return this.resumePreviousBy;
        }

        public void setResumePreviousBy(String resumePreviousBy) {
            this.resumePreviousBy = resumePreviousBy;
        }

        public List<ProcessArchiveXml> getProcessArchives() {
            ArrayList<ProcessArchiveXml> processArchives = new ArrayList<ProcessArchiveXml>();
            ProcessArchiveXmlImpl pa = new ProcessArchiveXmlImpl();
            processArchives.add((ProcessArchiveXml)pa);
            pa.setProcessResourceNames(Collections.emptyList());
            HashMap<String, String> properties = new HashMap<String, String>();
            pa.setProperties(properties);
            properties.put("isDeleteUponUndeploy", String.valueOf(this.isDeleteUponUndeploy));
            properties.put("isScanForProcessDefinitions", String.valueOf(this.isScanForProcessDefinitions));
            properties.put("isDeployChangedOnly", String.valueOf(this.isDeployChangedOnly));
            properties.put("resumePreviousBy", this.resumePreviousBy);
            return processArchives;
        }
    }

    public static class Webapp
    extends NestedProperty {
        private boolean indexRedirectEnabled = true;

        public boolean isIndexRedirectEnabled() {
            return this.indexRedirectEnabled;
        }

        public void setIndexRedirectEnabled(boolean indexRedirectEnabled) {
            this.indexRedirectEnabled = indexRedirectEnabled;
        }
    }

    public static class Jpa
    extends NestedProperty {
        private boolean enabled;
        private String persistenceUnitName;
        private boolean closeEntityManager = true;
        private boolean handleTransaction = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public void setPersistenceUnitName(String persistenceUnitName) {
            this.persistenceUnitName = persistenceUnitName;
        }

        public boolean isCloseEntityManager() {
            return this.closeEntityManager;
        }

        public void setCloseEntityManager(boolean closeEntityManager) {
            this.closeEntityManager = closeEntityManager;
        }

        public boolean isHandleTransaction() {
            return this.handleTransaction;
        }

        public void setHandleTransaction(boolean handleTransaction) {
            this.handleTransaction = handleTransaction;
        }
    }

    public static class Metrics
    extends NestedProperty {
        private boolean enabled = true;
        private MetricsRegistry metricsRegistry;
        private MetricsReporterIdProvider metricsReporterIdProvider;
        private DbMetricsReporter dbMetricsReporter;
        private boolean dbMetricsReporterActivate = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public DbMetricsReporter getDbMetricsReporter() {
            return this.dbMetricsReporter;
        }

        public void setDbMetricsReporter(DbMetricsReporter dbMetricsReporter) {
            this.dbMetricsReporter = dbMetricsReporter;
        }

        public boolean isDbMetricsReporterActivate() {
            return this.dbMetricsReporterActivate;
        }

        public void setDbMetricsReporterActivate(boolean dbMetricsReporterActivate) {
            this.dbMetricsReporterActivate = dbMetricsReporterActivate;
        }

        public MetricsRegistry getMetricsRegistry() {
            return this.metricsRegistry;
        }

        public void setMetricsRegistry(MetricsRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
        }

        public MetricsReporterIdProvider getMetricsReporterIdProvider() {
            return this.metricsReporterIdProvider;
        }

        public void setMetricsReporterIdProvider(MetricsReporterIdProvider metricsReporterIdProvider) {
            this.metricsReporterIdProvider = metricsReporterIdProvider;
        }
    }

    public static class Rest
    extends NestedProperty {
        private boolean enabled = true;
        private String mappedUrl = "/rest/*";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMappedUrl() {
            return this.mappedUrl;
        }

        public void setMappedUrl(String mappedUrl) {
            if (mappedUrl == null || mappedUrl.equals("/")) {
                mappedUrl = "/*";
            }
            if (!mappedUrl.startsWith("/")) {
                mappedUrl = "/" + mappedUrl;
            }
            mappedUrl = mappedUrl.equals("/") ? "/*" : mappedUrl + "/*";
            this.mappedUrl = mappedUrl;
        }
    }

    public static class JobExecution
    extends NestedProperty {
        private boolean enabled;
        private boolean active = true;
        private boolean deploymentAware;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isDeploymentAware() {
            return this.deploymentAware;
        }

        public void setDeploymentAware(boolean deploymentAware) {
            this.deploymentAware = deploymentAware;
        }
    }

    public static class Database
    extends NestedProperty {
        public static final List<String> SCHEMA_UPDATE_VALUES = Arrays.asList("true", "false", "create", "create-drop", "drop-create");
        private String schemaUpdate = "true";
        private String type;
        private String tablePrefix;

        public String getSchemaUpdate() {
            return this.schemaUpdate;
        }

        public void setSchemaUpdate(String schemaUpdate) {
            Assert.isTrue((boolean)SCHEMA_UPDATE_VALUES.contains(schemaUpdate), (String)String.format("schemaUpdate: '%s' is not valid (%s)", schemaUpdate, SCHEMA_UPDATE_VALUES));
            this.schemaUpdate = schemaUpdate;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTablePrefix() {
            return this.tablePrefix;
        }

        public void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }
    }

    static class NestedProperty {
        NestedProperty() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

