/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.actuator;

import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class JobExecutorHealthIndicator
extends AbstractHealthIndicator {
    private final JobExecutor jobExecutor;

    public JobExecutorHealthIndicator(JobExecutor jobExecutor) {
        Assert.notNull((Object)jobExecutor);
        this.jobExecutor = jobExecutor;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        boolean active = this.jobExecutor.isActive();
        builder = active ? builder.up() : builder.down();
        builder.withDetail("jobExecutor", (Object)Details.from(this.jobExecutor));
    }

    public static class Details {
        private String name;
        private String lockOwner;
        private int lockTimeInMillis;
        private int maxJobsPerAcquisition;
        private int waitTimeInMillis;
        private Set<String> processEngineNames = new HashSet<String>();

        private static Details from(JobExecutor jobExecutor) {
            Details details = new Details();
            details.name = jobExecutor.getName();
            details.lockOwner = jobExecutor.getLockOwner();
            details.lockTimeInMillis = jobExecutor.getLockTimeInMillis();
            details.maxJobsPerAcquisition = jobExecutor.getMaxJobsPerAcquisition();
            details.waitTimeInMillis = jobExecutor.getWaitTimeInMillis();
            for (ProcessEngineImpl processEngineImpl : jobExecutor.getProcessEngines()) {
                details.processEngineNames.add(processEngineImpl.getName());
            }
            return details;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public void setLockOwner(String lockOwner) {
            this.lockOwner = lockOwner;
        }

        public int getLockTimeInMillis() {
            return this.lockTimeInMillis;
        }

        public void setLockTimeInMillis(int lockTimeInMillis) {
            this.lockTimeInMillis = lockTimeInMillis;
        }

        public int getMaxJobsPerAcquisition() {
            return this.maxJobsPerAcquisition;
        }

        public void setMaxJobsPerAcquisition(int maxJobsPerAcquisition) {
            this.maxJobsPerAcquisition = maxJobsPerAcquisition;
        }

        public int getWaitTimeInMillis() {
            return this.waitTimeInMillis;
        }

        public void setWaitTimeInMillis(int waitTimeInMillis) {
            this.waitTimeInMillis = waitTimeInMillis;
        }

        public Set<String> getProcessEngineNames() {
            return this.processEngineNames;
        }

        public void setProcessEngineNames(Set<String> processEngineNames) {
            this.processEngineNames = processEngineNames;
        }
    }
}

